/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlock;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.freemarker.psi.FtlCompositeElementTypes;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.directives.FtlDirectiveType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlBlock
extends TemplateLanguageBlock {
    protected FtlBlock(@NotNull TemplateLanguageBlockFactory blockFactory, @NotNull CodeStyleSettings codeStyleSettings, @NotNull ASTNode node, @Nullable List<DataLanguageBlockWrapper> foreignChildren) {
        if (blockFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockFactory", "com/intellij/freemarker/psi/formatter/FtlBlock", "<init>"));
        }
        if (codeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeStyleSettings", "com/intellij/freemarker/psi/formatter/FtlBlock", "<init>"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/freemarker/psi/formatter/FtlBlock", "<init>"));
        }
        super(blockFactory, codeStyleSettings, node, foreignChildren);
    }

    public Indent getIndent() {
        if (this.getParent() == null || this.getParent().getParent() == null || this.isRootTagChild()) {
            return Indent.getNoneIndent();
        }
        IElementType type = this.getNode().getElementType();
        if (type instanceof FtlDirectiveType) {
            String directiveName = ((FtlDirectiveType)type).getDirectiveName();
            if (directiveName.equals("else") || directiveName.equals("elseIf")) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (type == FtlCompositeElementTypes.USER_DIRECTIVE) {
            return Indent.getNormalIndent();
        }
        return Indent.getNoneIndent();
    }

    private boolean isRootTagChild() {
        ASTNode parent = this.getNode().getTreeParent();
        return parent == null || parent.getElementType() == FtlCompositeElementTypes.ROOT_TAG;
    }

    protected IElementType getTemplateTextElementType() {
        return FtlElementTypes.TEMPLATE_TEXT;
    }

    @Nullable
    public Spacing getRightNeighborSpacing(@NotNull Block rightNeighbor, @NotNull DataLanguageBlockWrapper parent, int thisBlockIndex) {
        int i;
        if (rightNeighbor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightNeighbor", "com/intellij/freemarker/psi/formatter/FtlBlock", "getRightNeighborSpacing"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/freemarker/psi/formatter/FtlBlock", "getRightNeighborSpacing"));
        }
        List siblings = parent.getSubBlocks();
        for (i = thisBlockIndex - 1; i >= 0 && !(siblings.get(i) instanceof DataLanguageBlockWrapper); --i) {
        }
        return parent.getSpacing(i < 0 ? null : (Block)siblings.get(i), rightNeighbor);
    }

    protected Indent getChildIndent() {
        return Indent.getNoneIndent();
    }
}

