/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.variables;

import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlVariantsProcessor;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlDynamicMember;
import com.intellij.freemarker.psi.variables.FtlLightParameter;
import com.intellij.freemarker.psi.variables.FtlParameter;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlPsiType
extends FtlType {
    public static final Key<Boolean> STATIC_ERROR = Key.create((String)"STATIC_ERROR");
    private final PsiType myPsiType;
    private final boolean myStatic;

    public FtlPsiType(PsiType psiType, boolean aStatic) {
        this.myPsiType = psiType;
        this.myStatic = aStatic;
    }

    public FtlPsiType(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/freemarker/psi/variables/FtlPsiType", "<init>"));
        }
        this(psiType, false);
    }

    @NotNull
    public PsiType getPsiType() {
        PsiType psiType = this.myPsiType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/variables/FtlPsiType", "getPsiType"));
        }
        return psiType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FtlPsiType)) {
            return false;
        }
        FtlPsiType that = (FtlPsiType)o;
        return !(this.myPsiType != null ? !this.myPsiType.equals(that.myPsiType) : that.myPsiType != null);
    }

    public int hashCode() {
        return this.myPsiType != null ? this.myPsiType.hashCode() : 0;
    }

    @Nullable
    public static FtlPsiType wrap(@Nullable PsiType type) {
        return type == null ? null : new FtlPsiType(type);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull PsiElement place, ResolveState state) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/freemarker/psi/variables/FtlPsiType", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/freemarker/psi/variables/FtlPsiType", "processDeclarations"));
        }
        if (state.get(FtlQualifiedReference.RESOLVING_MACRO) == Boolean.TRUE) {
            return true;
        }
        if (this.myPsiType instanceof PsiClassType) {
            String hint;
            PsiClassType classType = (PsiClassType)this.myPsiType;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass == null || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.Map")) {
                return true;
            }
            ResolveState newState = state.put(PsiSubstitutor.KEY, (Object)resolveResult.getSubstitutor());
            String string = hint = processor instanceof FtlVariantsProcessor ? ((FtlVariantsProcessor)processor).getReferenceName() : null;
            if (!psiClass.processDeclarations((PsiScopeProcessor)new PsiMemberProcessor(processor, hint), newState, null, place)) {
                return false;
            }
            if (hint != null && !((FtlVariantsProcessor)processor).isMethodCall()) {
                String isAccessor = PropertyUtil.suggestGetterName((String)hint, (PsiType)PsiType.BOOLEAN);
                if (!psiClass.processDeclarations((PsiScopeProcessor)new PsiMemberProcessor(processor, isAccessor), newState, null, place)) {
                    return false;
                }
                String getAccessor = PropertyUtil.suggestGetterName((String)hint, (PsiType)PsiType.INT);
                if (!psiClass.processDeclarations((PsiScopeProcessor)new PsiMemberProcessor(processor, getAccessor), newState, null, place)) {
                    return false;
                }
            }
        }
        if (this.myStatic) {
            return true;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)place);
        if (module == null) {
            return true;
        }
        for (FtlFile file : FtlFile.getImplicitlyIncludedFiles(module)) {
            PsiFile javaFile = file.getViewProvider().getPsi(StdLanguages.JAVA);
            if (!(javaFile instanceof PsiJavaFile)) continue;
            for (PsiClass aClass : ((PsiJavaFile)javaFile).getClasses()) {
                for (PsiMethod method : aClass.getMethods()) {
                    FtlDynamicMember prop;
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    if (parameters.length <= 0 || !parameters[0].getType().isAssignableFrom(this.myPsiType)) continue;
                    FtlParameter[] ftlParameters = new FtlParameter[parameters.length - 1];
                    for (int i = 1; i < parameters.length; ++i) {
                        PsiParameter parameter = parameters[i];
                        ftlParameters[i - 1] = new FtlLightParameter(StringUtil.notNullize((String)parameter.getName()), (PsiElement)parameter, FtlPsiType.wrap(parameter.getType()));
                    }
                    final FtlPsiType returnType = FtlPsiType.wrap(method.getReturnType());
                    FtlDynamicMember variable = new FtlDynamicMember(method.getName(), method, (FtlType)new FtlCallableType(false, ftlParameters){

                        @Override
                        public FtlType getResultType() {
                            return returnType;
                        }
                    });
                    if (!processor.execute((PsiElement)variable, state)) {
                        return false;
                    }
                    if (!PropertyUtil.hasGetterName((PsiMethod)method) || parameters.length != 1 || processor.execute((PsiElement)(prop = new FtlDynamicMember(PropertyUtil.getPropertyNameByGetter((PsiMethod)method), method, (FtlType)returnType)), state)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String getPresentableText() {
        return this.myPsiType.getPresentableText();
    }

    private class PsiMemberProcessor
    extends BaseScopeProcessor
    implements NameHint {
        private final PsiScopeProcessor myDelegate;
        private final String myNameHint;

        public PsiMemberProcessor(PsiScopeProcessor delegate, String hint) {
            this.myDelegate = delegate;
            this.myNameHint = hint;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/psi/variables/FtlPsiType$PsiMemberProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/freemarker/psi/variables/FtlPsiType$PsiMemberProcessor", "execute"));
            }
            if (element instanceof PsiMember) {
                PsiMember member = (PsiMember)element;
                if (FtlPsiType.this.myStatic && !member.hasModifierProperty("static")) {
                    return this.myDelegate.execute(element, state.put(STATIC_ERROR, (Object)Boolean.TRUE));
                }
            }
            return this.myDelegate.execute(element, state);
        }

        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/freemarker/psi/variables/FtlPsiType$PsiMemberProcessor", "getHint"));
            }
            if (hintKey == NameHint.KEY && this.myNameHint != null) {
                return (T)((Object)this);
            }
            return null;
        }

        @Nullable
        public String getName(@NotNull ResolveState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/freemarker/psi/variables/FtlPsiType$PsiMemberProcessor", "getName"));
            }
            return this.myNameHint;
        }
    }
}

