/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.tools.klint.checks.ApiClass;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ApiParser
extends DefaultHandler {
    private static final String NODE_API = "api";
    private static final String NODE_CLASS = "class";
    private static final String NODE_FIELD = "field";
    private static final String NODE_METHOD = "method";
    private static final String NODE_EXTENDS = "extends";
    private static final String NODE_IMPLEMENTS = "implements";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SINCE = "since";
    private final Map<String, ApiClass> mClasses = new HashMap<String, ApiClass>();
    private ApiClass mCurrentClass;

    ApiParser() {
    }

    Map<String, ApiClass> getClasses() {
        return this.mClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName == null || localName.isEmpty()) {
            localName = qName;
        }
        try {
            if (NODE_API.equals(localName)) {
            } else if (NODE_CLASS.equals(localName)) {
                String name2 = attributes.getValue(ATTR_NAME);
                int since = Integer.parseInt(attributes.getValue(ATTR_SINCE));
                this.mCurrentClass = this.addClass(name2, since);
            } else if (NODE_EXTENDS.equals(localName)) {
                String name3 = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                this.mCurrentClass.addSuperClass(name3, since);
            } else if (NODE_IMPLEMENTS.equals(localName)) {
                String name4 = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                this.mCurrentClass.addInterface(name4, since);
            } else if (NODE_METHOD.equals(localName)) {
                String name5 = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                this.mCurrentClass.addMethod(name5, since);
            } else if (NODE_FIELD.equals(localName)) {
                String name6 = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                this.mCurrentClass.addField(name6, since);
            }
        }
        finally {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    private ApiClass addClass(String name2, int apiLevel) {
        ApiClass theClass = this.mClasses.get(name2);
        if (theClass == null) {
            theClass = new ApiClass(name2, apiLevel);
            this.mClasses.put(name2, theClass);
        }
        return theClass;
    }

    private int getSince(Attributes attributes) {
        int since = this.mCurrentClass.getSince();
        String sinceAttr = attributes.getValue(ATTR_SINCE);
        if (sinceAttr != null) {
            since = Integer.parseInt(sinceAttr);
        }
        return since;
    }
}

