/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.uml.java.JavaUmlCategoryManager;
import com.intellij.uml.java.JavaUmlEdge;
import com.intellij.uml.java.JavaUmlNode;
import com.intellij.uml.java.JavaUmlProvider;
import com.intellij.uml.java.JavaUmlRelationships;
import com.intellij.uml.java.dependency.JavaClassDependencyAnalyzer;
import com.intellij.uml.utils.UmlBundle;
import com.intellij.uml.utils.UmlJavaUtils;
import com.intellij.uml.utils.UmlPsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaUmlDataModel
extends DiagramDataModel<PsiElement> {
    private final Map<String, SmartPsiElementPointer<PsiClass>> classesAddedByUser = new HashMap<String, SmartPsiElementPointer<PsiClass>>();
    private final Map<String, SmartPsiElementPointer<PsiClass>> classesRemovedByUser = new HashMap<String, SmartPsiElementPointer<PsiClass>>();
    private SmartPsiElementPointer<PsiPackage> initialPackage = null;
    private List<SmartPsiElementPointer<PsiClass>> myInnerOnInit = new ArrayList<SmartPsiElementPointer<PsiClass>>();
    private SmartPsiElementPointer<PsiElement> myInitialElement;
    private final Map<String, SmartPsiElementPointer<PsiPackage>> packages = new HashMap<String, SmartPsiElementPointer<PsiPackage>>();
    private final Map<String, SmartPsiElementPointer<PsiPackage>> packagesRemovedByUser = new HashMap<String, SmartPsiElementPointer<PsiPackage>>();
    private boolean useInnerClasses = false;
    private final VirtualFile myEditorFile;
    private final DiagramPresentationModel myPresentationModel;
    private final SmartPointerManager spManager;
    private final Collection<DiagramNode<PsiElement>> myNodes = new HashSet<DiagramNode<PsiElement>>();
    private final Collection<DiagramEdge<PsiElement>> myEdges = new HashSet<DiagramEdge<PsiElement>>();
    private final Collection<DiagramEdge<PsiElement>> myDependencyEdges = new HashSet<DiagramEdge<PsiElement>>();
    private final Collection<DiagramNode<PsiElement>> myNodesOld = new HashSet<DiagramNode<PsiElement>>();
    private final Collection<DiagramEdge<PsiElement>> myEdgesOld = new HashSet<DiagramEdge<PsiElement>>();
    private final Collection<DiagramEdge<PsiElement>> myDependencyEdgesOld = new HashSet<DiagramEdge<PsiElement>>();

    public JavaUmlDataModel(Project project, @Nullable PsiElement psiElement, VirtualFile file, DiagramPresentationModel presentationModel) {
        super(project, DiagramProvider.findByID((String)"JAVA"));
        this.myEditorFile = file;
        this.myPresentationModel = presentationModel;
        this.spManager = SmartPointerManager.getInstance((Project)this.getProject());
        this.useInnerClasses = DiagramConfiguration.getConfiguration().isEnabledByDefault(this.getProvider(), JavaUmlCategoryManager.INNER_CLASSES.getName());
        this.init(psiElement);
    }

    private void init(PsiElement psiElement) {
        SmartPsiElementPointer<PsiElement> smartPsiElementPointer = this.myInitialElement = psiElement == null ? null : this.spManager.createSmartPsiElementPointer(psiElement);
        if (psiElement instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)psiElement;
            Set<PsiClass> classes = JavaUmlDataModel.getAllParentsForClass(psiClass);
            for (PsiClass aClass : classes) {
                this.classesAddedByUser.put(aClass.getQualifiedName(), (SmartPsiElementPointer<PsiClass>)this.spManager.createSmartPsiElementPointer((PsiElement)aClass));
            }
        }
        if (psiElement instanceof PsiPackage) {
            PsiPackage psiPackage = (PsiPackage)psiElement;
            this.initialPackage = this.spManager.createSmartPsiElementPointer((PsiElement)psiPackage);
            for (PsiClass psiClass : psiPackage.getClasses()) {
                this.classesAddedByUser.put(psiClass.getQualifiedName(), (SmartPsiElementPointer<PsiClass>)this.spManager.createSmartPsiElementPointer((PsiElement)psiClass));
                if (!this.useInnerClasses) continue;
                for (PsiClass aClass : UmlPsiUtil.getAllInnerClasses(psiClass)) {
                    this.classesAddedByUser.put(aClass.getQualifiedName(), (SmartPsiElementPointer<PsiClass>)this.spManager.createSmartPsiElementPointer((PsiElement)aClass));
                }
            }
            for (PsiClass psiClass : psiPackage.getSubPackages()) {
                if (!(psiClass instanceof PsiPackage)) continue;
                PsiPackage aPackage = (PsiPackage)psiClass;
                SmartPsiElementPointer pointer = this.spManager.createSmartPsiElementPointer((PsiElement)aPackage);
                this.packages.put(aPackage.getQualifiedName(), (SmartPsiElementPointer<PsiPackage>)pointer);
            }
        }
        this.updateInitialInnerClasses();
        this.myPresentationModel.getPresentation().setCategoryEnabled(JavaUmlCategoryManager.INNER_CLASSES, this.useInnerClasses);
    }

    private void updateInitialInnerClasses() {
        for (SmartPsiElementPointer<PsiClass> pointer : this.classesAddedByUser.values()) {
            PsiClass element = (PsiClass)pointer.getElement();
            if (element == null || !PsiUtil.isInnerClass((PsiClass)element)) continue;
            this.myInnerOnInit.add(pointer);
        }
    }

    @NotNull
    public Collection<DiagramNode<PsiElement>> getNodes() {
        Collection<DiagramNode<PsiElement>> collection = this.myNodes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/java/JavaUmlDataModel", "getNodes"));
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<PsiElement>> getEdges() {
        if (this.myDependencyEdges.isEmpty()) {
            Collection<DiagramEdge<PsiElement>> collection = this.myEdges;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/java/JavaUmlDataModel", "getEdges"));
            }
            return collection;
        }
        HashSet<DiagramEdge<PsiElement>> allEdges = new HashSet<DiagramEdge<PsiElement>>(this.myEdges);
        allEdges.addAll(this.myDependencyEdges);
        HashSet<DiagramEdge<PsiElement>> hashSet = allEdges;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/java/JavaUmlDataModel", "getEdges"));
        }
        return hashSet;
    }

    public void collapseToPackage(DiagramNode<PsiElement> umlNode) {
        PsiPackage psiPackage;
        PsiElement element = (PsiElement)umlNode.getIdentifyingElement();
        if (element instanceof PsiPackage) {
            psiPackage = ((PsiPackage)element).getParentPackage();
            if (psiPackage == null) {
                return;
            }
        } else {
            psiPackage = UmlJavaUtils.getPackage(element);
        }
        if (psiPackage == null || "".equals(psiPackage.getQualifiedName())) {
            return;
        }
        String fqnStart = psiPackage.getQualifiedName() + ".";
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String fqn : this.packages.keySet()) {
            if (!fqn.startsWith(fqnStart)) continue;
            toRemove.add(fqn);
        }
        for (String fqn : toRemove) {
            this.packages.remove(fqn);
        }
        toRemove.clear();
        for (String fqn : this.classesAddedByUser.keySet()) {
            if (!fqn.startsWith(fqnStart)) continue;
            toRemove.add(fqn);
        }
        for (String fqn : toRemove) {
            this.classesAddedByUser.remove(fqn);
        }
        this.packages.put(psiPackage.getQualifiedName(), (SmartPsiElementPointer<PsiPackage>)this.spManager.createSmartPsiElementPointer((PsiElement)psiPackage));
        this.packagesRemovedByUser.remove(psiPackage.getQualifiedName());
    }

    @NotNull
    @NonNls
    public String getNodeName(DiagramNode<PsiElement> node) {
        PsiElement element = (PsiElement)node.getIdentifyingElement();
        if (element instanceof PsiClass) {
            String string = "Class " + ((PsiClass)element).getQualifiedName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/java/JavaUmlDataModel", "getNodeName"));
            }
            return string;
        }
        if (element instanceof PsiPackage) {
            String string = "Package " + ((PsiPackage)element).getQualifiedName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/java/JavaUmlDataModel", "getNodeName"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/java/JavaUmlDataModel", "getNodeName"));
        }
        return "";
    }

    public DiagramEdge<PsiElement> createEdge(@NotNull DiagramNode<PsiElement> from, @NotNull DiagramNode<PsiElement> to) {
        String commandName;
        DiagramRelationshipInfo relationship;
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/uml/java/JavaUmlDataModel", "createEdge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/uml/java/JavaUmlDataModel", "createEdge"));
        }
        String[] errorHolder = new String[1];
        PsiClass fromClass = (PsiClass)from.getIdentifyingElement();
        PsiClass toClass = (PsiClass)to.getIdentifyingElement();
        PsiClass parent = (PsiClass)to.getIdentifyingElement();
        PsiClass child = (PsiClass)from.getIdentifyingElement();
        if (parent.isInterface()) {
            if (parent.isAnnotationType()) {
                relationship = JavaUmlRelationships.ANNOTATION;
                commandName = "Annotate " + fromClass.getName() + " with " + toClass.getName();
            } else {
                relationship = child.isInterface() ? JavaUmlRelationships.INTERFACE_GENERALIZATION : JavaUmlRelationships.REALIZATION;
                commandName = fromClass.getName() + (child.isInterface() ? " extends " : " implements ") + toClass.getName();
            }
        } else {
            if (fromClass.isEquivalentTo((PsiElement)toClass)) {
                return null;
            }
            relationship = JavaUmlRelationships.GENERALIZATION;
            commandName = fromClass.getName() + " extends " + toClass.getName();
        }
        Callable<JavaUmlEdge> callable = () -> {
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/uml/java/JavaUmlDataModel", "lambda$createEdge$0"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/uml/java/JavaUmlDataModel", "lambda$createEdge$0"));
            }
            try {
                errorHolder[0] = toClass.isAnnotationType() ? UmlPsiUtil.annotateClass(fromClass, toClass) : UmlPsiUtil.createInheritanceBetween(fromClass, toClass);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
            if (errorHolder[0] != null) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new Exception(errorHolder[0]);
                }
                Messages.showErrorDialog((Project)((PsiElement)from.getIdentifyingElement()).getProject(), (String)errorHolder[0], (String)UmlBundle.message("error.cant.create.edge", new Object[0]));
                return null;
            }
            JavaUmlEdge edge = new JavaUmlEdge(from, to, relationship);
            this.myEdges.add((DiagramEdge<PsiElement>)edge);
            DiagramBuilder builder = this.getBuilder();
            if (builder != null) {
                builder.update(true, false);
            }
            if (!UmlPsiUtil.isAbstract(child) && !OverrideImplementUtil.getMethodSignaturesToImplement((PsiClass)child).isEmpty()) {
                int code;
                Project project = builder.getProject();
                int n = code = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showOkCancelDialog((Project)project, (String)UmlBundle.message("class.must.be.abstract.or.implement.methods", child.getName()), (String)UmlBundle.message("class.must.be.abstract.title", new Object[0]), (String)UmlBundle.message("generate.methods", new Object[0]), (String)UmlBundle.message("make.abstract", new Object[0]), (Icon)Messages.getQuestionIcon());
                if (code == 0) {
                    VirtualFile vf;
                    PsiFile psiFile = child.getContainingFile();
                    if (psiFile == null || (vf = psiFile.getVirtualFile()) == null) {
                        return null;
                    }
                    Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, vf), false);
                    OverrideImplementUtil.chooseAndImplementMethods((Project)project, (Editor)editor, (PsiClass)child);
                    if (!ApplicationManager.getApplication().isUnitTestMode()) {
                        FileEditorManager.getInstance((Project)project).openFile(this.myEditorFile, true);
                    }
                } else {
                    UmlPsiUtil.makeClassAbstract(child);
                }
            }
            return edge;
        };
        return (DiagramEdge)DiagramAction.performCommand((DiagramBuilder)this.getBuilder(), callable, (String)commandName, null, (PsiElement[])new PsiElement[]{((PsiElement)from.getIdentifyingElement()).getContainingFile()});
    }

    public void removeNode(DiagramNode<PsiElement> node) {
        this.removeElement((PsiElement)node.getIdentifyingElement());
    }

    public void removeEdge(DiagramEdge<PsiElement> edge) {
        PsiElement source = (PsiElement)edge.getSource().getIdentifyingElement();
        PsiElement target = (PsiElement)edge.getTarget().getIdentifyingElement();
        DiagramRelationshipInfo relationship = edge.getRelationship();
        if (source instanceof PsiClass && target instanceof PsiClass && relationship != DiagramRelationshipInfo.NO_RELATIONSHIP) {
            int exitCode;
            PsiClass src = (PsiClass)source;
            PsiClass trg = (PsiClass)target;
            int n = exitCode = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoDialog((Project)src.getProject(), (String)JavaUmlDataModel.getMessage(src, trg, relationship), (String)UmlBundle.message("remove.relationship.link", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (exitCode == 0) {
                String commandName = "Remove link between " + src.getName() + " and " + trg.getName();
                Runnable runnable = () -> {
                    if (UmlJavaUtils.prepareClassForWrite(src)) {
                        try {
                            PsiModifierList list;
                            PsiReferenceList extendsList = src.getExtendsList();
                            PsiReferenceList implementsList = src.getImplementsList();
                            if (relationship == JavaUmlRelationships.GENERALIZATION || relationship == JavaUmlRelationships.INTERFACE_GENERALIZATION) {
                                RefactoringUtil.removeFromReferenceList((PsiReferenceList)extendsList, (PsiClass)trg);
                            } else if (relationship == JavaUmlRelationships.REALIZATION) {
                                if (src.isInterface()) {
                                    RefactoringUtil.removeFromReferenceList((PsiReferenceList)extendsList, (PsiClass)trg);
                                } else {
                                    RefactoringUtil.removeFromReferenceList((PsiReferenceList)implementsList, (PsiClass)trg);
                                }
                            } else if (relationship == JavaUmlRelationships.ANNOTATION && (list = src.getModifierList()) != null) {
                                for (PsiAnnotation annotation : list.getAnnotations()) {
                                    if (!annotation.isPhysical() || !annotation.isValid() || !Comparing.equal((String)annotation.getQualifiedName(), (String)trg.getQualifiedName())) continue;
                                    annotation.delete();
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                DiagramAction.performCommand((DiagramBuilder)this.getBuilder(), (Runnable)runnable, (String)commandName, null, (PsiElement[])new PsiElement[]{source.getContainingFile()});
            }
        }
    }

    public void refreshDataModel() {
        this.clearAll();
        boolean useInner = false;
        for (DiagramCategory category : this.getBuilder().getPresentation().getEnabledCategories()) {
            if (category != JavaUmlCategoryManager.INNER_CLASSES) continue;
            useInner = true;
            break;
        }
        this.useInnerClasses = useInner;
        this.updateDataModel();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/java/JavaUmlDataModel", "getModificationTracker"));
        }
        return psiModificationTracker;
    }

    private void clearAll() {
        JavaUmlDataModel.clearAndBackup(this.myNodes, this.myNodesOld);
        JavaUmlDataModel.clearAndBackup(this.myEdges, this.myEdgesOld);
        JavaUmlDataModel.clearAndBackup(this.myDependencyEdges, this.myDependencyEdgesOld);
    }

    private boolean isAllowedToShow(PsiClass psiClass) {
        if (psiClass == null || !psiClass.isValid()) {
            return false;
        }
        for (SmartPsiElementPointer<PsiClass> pointer : this.classesRemovedByUser.values()) {
            if (!psiClass.equals(pointer.getElement())) continue;
            return false;
        }
        DiagramScopeManager scopeManager = this.getScopeManager();
        if (scopeManager != null && !scopeManager.contains((Object)psiClass)) {
            return false;
        }
        PsiElement initialElement = this.getInitialElement();
        if (this.isInsidePackages(psiClass)) {
            return false;
        }
        if (initialElement instanceof PsiClass && JavaUmlDataModel.equals(psiClass, (PsiClass)initialElement)) {
            return true;
        }
        if (!this.useInnerClasses && PsiUtil.isInnerClass((PsiClass)psiClass)) {
            for (SmartPsiElementPointer<PsiClass> pointer : this.myInnerOnInit) {
                if (!psiClass.equals(pointer.getElement())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean equals(PsiClass one, PsiClass another) {
        return one != null && one.isValid() && another != null && another.isValid() && Comparing.equal((String)one.getQualifiedName(), (String)another.getQualifiedName());
    }

    public synchronized void updateDataModel() {
        JavaUmlProvider umlProvider = (JavaUmlProvider)this.getBuilder().getProvider();
        final Set<PsiClass> classes = this.getAllClasses();
        this.syncPackages();
        HashSet<String> interfaces = new HashSet<String>();
        HashSet<String> annotations = new HashSet<String>();
        Set<String> packageFqns = this.packages.keySet();
        for (SmartPsiElementPointer<PsiPackage> ptr : this.packages.values()) {
            String fqn;
            PsiPackage psiPackage;
            if (ptr == null || (psiPackage = (PsiPackage)ptr.getElement()) == null || !this.isAllowedToShow(psiPackage) || (fqn = UmlJavaUtils.getFQN((PsiElement)psiPackage)) == null) continue;
            boolean doNotAdd = false;
            for (String packageFqn : packageFqns) {
                if (fqn.length() <= packageFqn.length() || !fqn.startsWith(packageFqn + ".")) continue;
                doNotAdd = true;
                break;
            }
            if (doNotAdd) continue;
            this.myNodes.add((DiagramNode<PsiElement>)new JavaUmlNode((PsiElement)psiPackage, umlProvider));
        }
        for (PsiClass psiClass : classes) {
            if (this.isAllowedToShow(psiClass)) {
                this.myNodes.add((DiagramNode<PsiElement>)new JavaUmlNode((PsiElement)psiClass, umlProvider));
            }
            if (psiClass.isAnnotationType()) {
                annotations.add(psiClass.getQualifiedName());
                continue;
            }
            if (!psiClass.isInterface()) continue;
            interfaces.add(psiClass.getQualifiedName());
        }
        for (PsiClass psiClass : classes) {
            DiagramNode<PsiElement> target;
            DiagramNode<PsiElement> source;
            if (JavaUmlDataModel.isGeneralizationEdgeAllowed(psiClass)) {
                DiagramNode<PsiElement> source2 = this.findNode((PsiElement)psiClass);
                DiagramNode<PsiElement> target2 = null;
                for (PsiClass superClass = psiClass.getSuperClass(); target2 == null && superClass != null; superClass = superClass.getSuperClass()) {
                    target2 = this.findNode((PsiElement)superClass);
                }
                if (source2 != null && target2 != null && source2 != target2) {
                    this.addEdge(source2, target2, JavaUmlRelationships.GENERALIZATION);
                }
            }
            for (PsiClass inter : psiClass.getInterfaces()) {
                if (!interfaces.contains(inter.getQualifiedName())) continue;
                source = this.findNode((PsiElement)psiClass);
                target = this.findNode((PsiElement)inter);
                if (source == null || target == null || source == target) continue;
                this.addEdge(source, target, psiClass.isInterface() ? JavaUmlRelationships.INTERFACE_GENERALIZATION : JavaUmlRelationships.REALIZATION);
            }
            if (psiClass.isInterface()) {
                HashSet<PsiClass> found = new HashSet<PsiClass>();
                JavaUmlDataModel.findNearestInterfaces(psiClass, interfaces, found);
                for (PsiClass inter : found) {
                    DiagramNode<PsiElement> source3 = this.findNode((PsiElement)psiClass);
                    DiagramNode<PsiElement> target3 = this.findNode((PsiElement)inter);
                    if (source3 == null || target3 == null || source3 == target3) continue;
                    this.addEdge(source3, target3, JavaUmlRelationships.INTERFACE_GENERALIZATION);
                }
            } else {
                HashSet inters = new HashSet();
                ContainerUtil.addAll(inters, (Object[])psiClass.getInterfaces());
                for (PsiClass cur = psiClass.getSuperClass(); cur != null && this.findNode((PsiElement)cur) == null; cur = cur.getSuperClass()) {
                    ContainerUtil.addAll(inters, (Object[])cur.getInterfaces());
                }
                ArrayList faces = new ArrayList(inters);
                while (!faces.isEmpty()) {
                    PsiClass inter;
                    inter = (PsiClass)faces.get(0);
                    if (this.findNode((PsiElement)inter) != null) {
                        source = this.findNode((PsiElement)psiClass);
                        target = this.findNode((PsiElement)inter);
                        if (source != null && target != null && source != target) {
                            this.addEdge(source, target, JavaUmlRelationships.REALIZATION);
                        }
                        faces.remove(inter);
                        continue;
                    }
                    faces.remove(inter);
                    ContainerUtil.addAll(faces, (Object[])inter.getInterfaces());
                }
            }
            if (!this.isInsidePackages(psiClass) && this.useInnerClasses) {
                for (PsiClass inner : psiClass.getInnerClasses()) {
                    if (!classes.contains(inner)) continue;
                    source = this.findNode((PsiElement)inner);
                    target = this.findNode((PsiElement)psiClass);
                    if (source == null || target == null || source == target) continue;
                    this.addEdge(source, target, JavaUmlRelationships.INNER_CLASS);
                }
            }
            for (PsiClass annotation : UmlPsiUtil.findAnnotationsForClass(psiClass)) {
                if (!annotations.contains(annotation.getQualifiedName())) continue;
                DiagramNode<PsiElement> source4 = this.findNode((PsiElement)psiClass);
                DiagramNode<PsiElement> target4 = this.findNode((PsiElement)annotation);
                if (source4 == null || target4 == null || source4 == target4) continue;
                this.addEdge(source4, target4, JavaUmlRelationships.ANNOTATION);
            }
        }
        if (this.isShowDependencies()) {
            Task.Backgroundable task = new Task.Backgroundable(this.getProject(), "Calculating dependencies", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/uml/java/JavaUmlDataModel$1", "run"));
                    }
                    ApplicationManager.getApplication().runReadAction(() -> {
                        for (PsiClass psiClass : classes) {
                            JavaUmlDataModel.this.showDependenciesFor(psiClass);
                        }
                        JavaUmlDataModel.this.getBuilder().update();
                    });
                }
            };
            ProgressManager.getInstance().run((Task)task);
        }
        JavaUmlDataModel.mergeWithBackup(this.myNodes, this.myNodesOld);
        JavaUmlDataModel.mergeWithBackup(this.myEdges, this.myEdgesOld);
        JavaUmlDataModel.mergeWithBackup(this.myDependencyEdges, this.myDependencyEdgesOld);
    }

    private boolean isAllowedToShow(@NotNull PsiPackage aPackage) {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "com/intellij/uml/java/JavaUmlDataModel", "isAllowedToShow"));
        }
        if (!aPackage.isValid()) {
            return false;
        }
        DiagramScopeManager scopeManager = this.getScopeManager();
        return scopeManager == null || scopeManager.contains((Object)aPackage);
    }

    private static <T> void clearAndBackup(Collection<T> target, Collection<T> backup) {
        backup.clear();
        backup.addAll(target);
        target.clear();
    }

    private static <T> void mergeWithBackup(Collection<T> target, Collection<T> backup) {
        for (T t : backup) {
            if (!target.contains(t)) continue;
            target.remove(t);
            target.add(t);
        }
    }

    private void syncPackages() {
        if (this.initialPackage == null) {
            return;
        }
        PsiPackage initPackage = (PsiPackage)this.initialPackage.getElement();
        if (initPackage == null) {
            return;
        }
        HashMap<String, PsiPackage> psiPackages = new HashMap<String, PsiPackage>();
        for (PsiPackage sub : initPackage.getSubPackages()) {
            psiPackages.put(sub.getQualifiedName(), sub);
        }
        for (String fqn : this.packages.keySet()) {
            psiPackages.remove(fqn);
        }
        for (String fqn : this.packagesRemovedByUser.keySet()) {
            psiPackages.remove(fqn);
        }
        if (psiPackages.size() > 0) {
            for (PsiPackage psiPackage : psiPackages.values()) {
                this.packages.put(psiPackage.getQualifiedName(), (SmartPsiElementPointer<PsiPackage>)this.spManager.createSmartPsiElementPointer((PsiElement)psiPackage));
            }
        }
    }

    private static void findNearestInterfaces(PsiClass psiClass, Set<String> interfaces, Set<PsiClass> found) {
        for (PsiClass inter : psiClass.getInterfaces()) {
            if (interfaces.contains(inter.getQualifiedName())) {
                found.add(inter);
                continue;
            }
            JavaUmlDataModel.findNearestInterfaces(inter, interfaces, found);
        }
    }

    private static boolean isGeneralizationEdgeAllowed(PsiClass psiClass) {
        return !psiClass.isInterface() && !psiClass.isAnnotationType();
    }

    private boolean isInsidePackages(PsiClass psiClass) {
        String fqn = UmlJavaUtils.getFQN((PsiElement)psiClass);
        if (fqn != null) {
            for (String packageFqn : this.packages.keySet()) {
                if (!fqn.startsWith(packageFqn + ".")) continue;
                return true;
            }
        }
        return false;
    }

    public void addEdge(DiagramNode<PsiElement> from, DiagramNode<PsiElement> to, DiagramRelationshipInfo relationship) {
        JavaUmlDataModel.addEdge(from, to, relationship, this.myEdges);
    }

    public void addDependencyEdge(DiagramNode<PsiElement> from, DiagramNode<PsiElement> to, DiagramRelationshipInfo relationship) {
        JavaUmlDataModel.addEdge(from, to, relationship, this.myDependencyEdges);
    }

    private static void addEdge(DiagramNode<PsiElement> from, DiagramNode<PsiElement> to, DiagramRelationshipInfo relationship, Collection<DiagramEdge<PsiElement>> storage) {
        for (DiagramEdge<PsiElement> edge : storage) {
            if (edge.getSource() != from || edge.getTarget() != to || edge.getRelationship() != relationship) continue;
            return;
        }
        storage.add((DiagramEdge<PsiElement>)new JavaUmlEdge(from, to, relationship));
    }

    private Set<PsiClass> getAllClasses() {
        Object initPackage;
        HashSet<PsiClass> classes = new HashSet<PsiClass>();
        for (SmartPsiElementPointer<PsiClass> smartPsiElementPointer : this.classesAddedByUser.values()) {
            PsiClass psiClass = (PsiClass)smartPsiElementPointer.getElement();
            classes.add(psiClass);
        }
        if (this.initialPackage != null && (initPackage = (PsiPackage)this.initialPackage.getElement()) != null) {
            ContainerUtil.addAll(classes, (Object[])initPackage.getClasses());
        }
        for (SmartPsiElementPointer smartPsiElementPointer : this.packages.values()) {
            PsiPackage psiPackage;
            if (smartPsiElementPointer == null || (psiPackage = (PsiPackage)smartPsiElementPointer.getElement()) == null) continue;
            ContainerUtil.addAll(classes, (Object[])psiPackage.getClasses());
        }
        classes.remove(null);
        HashSet<PsiClass> temp = new HashSet<PsiClass>();
        if (this.useInnerClasses) {
            for (PsiClass psiClass : classes) {
                temp.addAll(UmlPsiUtil.getAllInnerClasses(psiClass));
            }
            classes.addAll(temp);
            temp.clear();
        }
        classes.remove(null);
        for (PsiClass psiClass : classes) {
            if (psiClass.isValid()) continue;
            temp.add(psiClass);
        }
        for (SmartPsiElementPointer<PsiClass> smartPsiElementPointer : this.classesRemovedByUser.values()) {
            classes.remove(smartPsiElementPointer.getElement());
        }
        classes.removeAll(temp);
        return classes;
    }

    private static Set<PsiClass> getAllParentsForClass(PsiClass cl) {
        return JavaUmlDataModel.findAllParentsForClass(cl, new HashSet<PsiClass>());
    }

    private static Set<PsiClass> findAllParentsForClass(@NotNull PsiClass clazz, @NotNull Set<PsiClass> found) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/uml/java/JavaUmlDataModel", "findAllParentsForClass"));
        }
        if (found == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "found", "com/intellij/uml/java/JavaUmlDataModel", "findAllParentsForClass"));
        }
        found.add(clazz);
        for (PsiClass psiClass : clazz.getSupers()) {
            if (psiClass.getSuperClass() != null) {
                found.add(psiClass);
                JavaUmlDataModel.findAllParentsForClass(psiClass, found);
                continue;
            }
            if (clazz.isInterface() || JavaUmlDataModel.isJavaLangObject(psiClass)) continue;
            found.add(psiClass);
        }
        PsiModifierList modifierList = clazz.getModifierList();
        if (modifierList != null) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = modifierList.getAnnotations()) {
                PsiClass anno = UmlPsiUtil.findAnnotationClass(annotation);
                if (anno == null) continue;
                found.add(anno);
            }
        }
        return found;
    }

    private static boolean isJavaLangObject(PsiClass cls) {
        return cls != null && "java.lang.Object".equals(cls.getQualifiedName());
    }

    @Nullable
    public DiagramNode<PsiElement> findNode(PsiElement psiElement) {
        for (DiagramNode<PsiElement> node : new ArrayList<DiagramNode<PsiElement>>(this.myNodes)) {
            String fqn = UmlJavaUtils.getFQN((PsiElement)node.getIdentifyingElement());
            if (fqn == null || !fqn.equals(UmlJavaUtils.getFQN(psiElement))) continue;
            return node;
        }
        SmartPsiElementPointer<PsiPackage> ptr = this.packages.get(UmlJavaUtils.getPackageName(psiElement));
        return ptr == null || ptr.getElement() == psiElement ? null : this.findNode(ptr.getElement());
    }

    public void dispose() {
    }

    public void removeElement(PsiElement element) {
        DiagramNode<PsiElement> node = this.findNode(element);
        if (node == null) {
            this.classesAddedByUser.remove(UmlJavaUtils.getFQN(element));
            return;
        }
        ArrayList<PsiClass[]> edges = new ArrayList<PsiClass[]>();
        for (DiagramEdge<PsiElement> edge : this.myEdges) {
            if (!edge.getTarget().equals(node) && !edge.getSource().equals(node)) continue;
            edges.add((PsiClass[])edge);
        }
        for (DiagramEdge<PsiElement> edge : this.myDependencyEdges) {
            if (!edge.getTarget().equals(node) && !edge.getSource().equals(node)) continue;
            edges.add((PsiClass[])edge);
        }
        this.myEdges.removeAll(edges);
        this.myDependencyEdges.removeAll(edges);
        this.myNodes.remove(node);
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            this.classesRemovedByUser.put(psiClass.getQualifiedName(), (SmartPsiElementPointer<PsiClass>)this.spManager.createSmartPsiElementPointer((PsiElement)psiClass));
            this.classesAddedByUser.remove(psiClass.getQualifiedName());
            for (PsiClass innerClass : psiClass.getInnerClasses()) {
                this.classesRemovedByUser.put(innerClass.getQualifiedName(), (SmartPsiElementPointer<PsiClass>)this.spManager.createSmartPsiElementPointer((PsiElement)innerClass));
                this.classesAddedByUser.remove(innerClass.getQualifiedName());
            }
        }
        if (element instanceof PsiPackage) {
            PsiPackage p = (PsiPackage)element;
            this.packages.remove(p.getQualifiedName());
            this.packagesRemovedByUser.put(p.getQualifiedName(), (SmartPsiElementPointer<PsiPackage>)this.spManager.createSmartPsiElementPointer((PsiElement)p));
            HashSet<String> toDelete = new HashSet<String>();
            for (String key : this.classesAddedByUser.keySet()) {
                SmartPsiElementPointer<PsiClass> pointer = this.classesAddedByUser.get(key);
                PsiClass psiClass = (PsiClass)pointer.getElement();
                if (!Comparing.equal((String)p.getQualifiedName(), (String)UmlJavaUtils.getRealPackageName((PsiElement)psiClass))) continue;
                toDelete.add(key);
            }
            for (String key : toDelete) {
                this.classesAddedByUser.remove(key);
            }
        }
    }

    @Nullable
    public DiagramNode<PsiElement> addElement(PsiElement element) {
        if (this.findNode(element) != null) {
            return null;
        }
        if (element instanceof PsiPackage) {
            PsiPackage psiPackage = (PsiPackage)element;
            String fqn = psiPackage.getQualifiedName();
            if (fqn.length() == 0) {
                return null;
            }
            for (String packageFqn : this.packages.keySet()) {
                if (!fqn.startsWith(packageFqn + ".")) continue;
                return null;
            }
            this.packages.put(fqn, (SmartPsiElementPointer<PsiPackage>)this.spManager.createSmartPsiElementPointer((PsiElement)psiPackage));
            this.packagesRemovedByUser.remove(fqn);
        } else if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            if (this.isModelInitializationFinished()) {
                this.setupScopeManager(psiClass, true);
                if (psiClass.getQualifiedName() == null || this.isInsidePackages(psiClass)) {
                    return null;
                }
                SmartPsiElementPointer pointer = this.spManager.createSmartPsiElementPointer((PsiElement)psiClass);
                String fqn = psiClass.getQualifiedName();
                this.classesAddedByUser.put(fqn, (SmartPsiElementPointer<PsiClass>)pointer);
                this.classesRemovedByUser.remove(fqn);
                if (PsiUtil.isInnerClass((PsiClass)psiClass) && !this.useInnerClasses) {
                    this.useInnerClasses = true;
                    this.getBuilder().getPresentation().setCategoryEnabled(JavaUmlCategoryManager.INNER_CLASSES, true);
                }
            } else {
                Set<PsiClass> classes = JavaUmlDataModel.getAllParentsForClass(psiClass);
                for (PsiClass aClass : classes) {
                    String fqn = aClass.getQualifiedName();
                    if (this.classesAddedByUser.containsKey(fqn)) continue;
                    this.classesAddedByUser.put(fqn, (SmartPsiElementPointer<PsiClass>)this.spManager.createSmartPsiElementPointer((PsiElement)aClass));
                }
                this.updateInitialInnerClasses();
            }
        } else {
            return null;
        }
        return new JavaUmlNode(element, (DiagramProvider<PsiElement>)this.getBuilder().getProvider());
    }

    public void expandPackage(PsiPackage psiPackage) {
        this.packages.remove(psiPackage.getQualifiedName());
        this.packagesRemovedByUser.put(psiPackage.getQualifiedName(), (SmartPsiElementPointer<PsiPackage>)this.spManager.createSmartPsiElementPointer((PsiElement)psiPackage));
        for (PsiClass psiClass : psiPackage.getClasses()) {
            this.addElement((PsiElement)psiClass);
            for (PsiClass inner : psiClass.getInnerClasses()) {
                this.addElement((PsiElement)inner);
            }
        }
        for (PsiClass psiClass : psiPackage.getSubPackages()) {
            this.addElement((PsiElement)psiClass);
        }
    }

    private void showDependenciesFor(PsiClass psiClass) {
        DiagramNode<PsiElement> node;
        DiagramNode<PsiElement> mainNode = this.findNode((PsiElement)psiClass);
        if (mainNode == null) {
            return;
        }
        JavaClassDependencyAnalyzer analizer = new JavaClassDependencyAnalyzer(psiClass);
        List<Pair<PsiClass, DiagramRelationshipInfo>> list = analizer.computeUsedClasses();
        for (Pair<PsiClass, DiagramRelationshipInfo> pair : list) {
            node = this.findNode((PsiElement)pair.first);
            if (node == null) continue;
            this.addDependencyEdge(mainNode, node, (DiagramRelationshipInfo)pair.second);
        }
        list = analizer.computeUsingClasses();
        for (Pair<PsiClass, DiagramRelationshipInfo> pair : list) {
            node = this.findNode((PsiElement)pair.first);
            if (node == null) continue;
            this.addDependencyEdge(node, mainNode, (DiagramRelationshipInfo)pair.second);
        }
    }

    @Nullable
    public PsiElement getInitialElement() {
        if (this.myInitialElement == null) {
            return null;
        }
        PsiElement element = this.myInitialElement.getElement();
        return element == null || !element.isValid() ? null : element;
    }

    public static String getMessage(PsiClass source, PsiClass target, DiagramRelationshipInfo relationship) {
        if (relationship == JavaUmlRelationships.ANNOTATION) {
            return UmlBundle.message("remove.annotation.from.class", target.getName(), source.getName());
        }
        return UmlBundle.message("this.will.remove.relationship.link.between.classes", source.getQualifiedName());
    }

    public boolean hasElement(PsiElement element) {
        return this.findNode(element) != null;
    }

    public boolean isDependencyDiagramSupported() {
        return true;
    }

    public void collapseNode(DiagramNode<PsiElement> node) {
        this.collapseToPackage(node);
    }

    public void expandNode(DiagramNode<PsiElement> node) {
        PsiElement element = (PsiElement)node.getIdentifyingElement();
        if (element instanceof PsiPackage) {
            this.expandPackage((PsiPackage)element);
        }
    }

    public boolean isPsiListener() {
        return true;
    }

    public void rebuild(PsiElement element) {
        super.rebuild((Object)element);
        this.classesAddedByUser.clear();
        this.classesRemovedByUser.clear();
        this.packages.clear();
        this.packagesRemovedByUser.clear();
        this.clearAll();
        this.myNodesOld.clear();
        this.myEdgesOld.clear();
        this.myDependencyEdgesOld.clear();
        this.init(element);
        this.refreshDataModel();
    }
}

