/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.tree.injected.StringLiteralEscaper;
import com.intellij.psi.tree.IElementType;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlArgumentList;
import com.intellij.velocity.psi.VtlCompositeElement;
import com.intellij.velocity.psi.VtlCompositeElementType;
import com.intellij.velocity.psi.VtlCompositeElementTypes;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.VtlRangeExpression;
import com.intellij.velocity.psi.directives.VtlDirective;
import com.intellij.velocity.psi.directives.VtlFileReferenceDirective;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VtlLiteralExpressionType
extends VtlCompositeElementType {
    private final String myTypeName;
    private final PsiPrimitiveType myPrimitiveType;

    public VtlLiteralExpressionType(@NotNull @NonNls String debugName, @NotNull String typeName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/velocity/psi/VtlLiteralExpressionType", "<init>"));
        }
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/velocity/psi/VtlLiteralExpressionType", "<init>"));
        }
        super(debugName);
        this.myTypeName = typeName;
        this.myPrimitiveType = null;
    }

    public VtlLiteralExpressionType(@NotNull @NonNls String debugName, @NotNull PsiType primitiveType) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/velocity/psi/VtlLiteralExpressionType", "<init>"));
        }
        if (primitiveType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primitiveType", "com/intellij/velocity/psi/VtlLiteralExpressionType", "<init>"));
        }
        super(debugName);
        this.myTypeName = null;
        assert (primitiveType instanceof PsiPrimitiveType);
        this.myPrimitiveType = (PsiPrimitiveType)primitiveType;
    }

    @Override
    public PsiElement createPsiElement(ASTNode node) {
        return VtlCompositeElementTypes.STRING_LITERALS.contains((IElementType)this) ? new VtlStringLiteral(node) : new VtlLiteralExpression(node);
    }

    public class VtlStringLiteral
    extends VtlLiteralExpression
    implements PsiLanguageInjectionHost {
        public VtlStringLiteral(ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/velocity/psi/VtlLiteralExpressionType$VtlStringLiteral", "<init>"));
            }
            super(node);
        }

        @NotNull
        public PsiReference[] getReferences() {
            if (this.isFileReference()) {
                FileReference[] fileReferenceArray = PsiUtil.getFileReferences(this.getValueText(), this, this.getFirstChild().getTextLength(), true);
                if (fileReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlLiteralExpressionType$VtlStringLiteral", "getReferences"));
                }
                return fileReferenceArray;
            }
            if (this.isPropertyReference()) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new PropertyReference(this.getValueText(), (PsiElement)this, null, true)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlLiteralExpressionType$VtlStringLiteral", "getReferences"));
                }
                return psiReferenceArray;
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlLiteralExpressionType$VtlStringLiteral", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private boolean isFileReference() {
            return this.isStringLiteralAndArgumentOf(VtlFileReferenceDirective.class);
        }

        private boolean isPropertyReference() {
            String valueText = this.getValueText();
            return !valueText.contains(" ");
        }

        private String getValueText() {
            String text = this.getText();
            return text.substring(1, text.length() - 1);
        }

        private boolean isStringLiteralAndArgumentOf(Class<? extends VtlDirective> directiveClass) {
            PsiElement parent = this.getParent();
            return parent instanceof VtlArgumentList && directiveClass.isInstance(parent.getParent());
        }

        @NotNull
        public TextRange getValueRange() {
            TextRange textRange = new TextRange(1, this.getText().length() - 1);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlLiteralExpressionType$VtlStringLiteral", "getValueRange"));
            }
            return textRange;
        }

        public VtlStringLiteral setStringValue(TextRange range, String newContent) {
            String oldText = this.getText();
            String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
            VtlStringLiteral newElement = PsiUtil.createStringLiteral(this.getProject(), newText);
            ASTNode newNode = newElement.getNode();
            this.getParent().getNode().replaceChild(this.getNode(), newNode);
            return (VtlStringLiteral)newNode.getPsi();
        }

        public boolean isValidHost() {
            return true;
        }

        public VtlStringLiteral updateText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/velocity/psi/VtlLiteralExpressionType$VtlStringLiteral", "updateText"));
            }
            this.setStringValue(this.getValueRange(), text);
            return this;
        }

        @NotNull
        public LiteralTextEscaper<VtlStringLiteral> createLiteralTextEscaper() {
            StringLiteralEscaper stringLiteralEscaper = new StringLiteralEscaper((PsiLanguageInjectionHost)this);
            if (stringLiteralEscaper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlLiteralExpressionType$VtlStringLiteral", "createLiteralTextEscaper"));
            }
            return stringLiteralEscaper;
        }
    }

    public class VtlLiteralExpression
    extends VtlCompositeElement
    implements VtlExpression {
        public VtlLiteralExpression(ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/velocity/psi/VtlLiteralExpressionType$VtlLiteralExpression", "<init>"));
            }
            super(node);
        }

        @Override
        public PsiType getPsiType() {
            VtlRangeExpression range;
            if (this.getNode().getElementType() == VtlCompositeElementTypes.LIST_EXPRESSION && (range = (VtlRangeExpression)this.findChildByClass(VtlRangeExpression.class)) != null) {
                return range.getPsiType();
            }
            if (VtlLiteralExpressionType.this.myPrimitiveType != null) {
                return VtlLiteralExpressionType.this.myPrimitiveType;
            }
            return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeByFQClassName(VtlLiteralExpressionType.this.myTypeName, this.getResolveScope());
        }
    }
}

