/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.parsers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.psi.VtlCompositeStarterTokenType;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.parsers.CompositeBodyParser;
import com.intellij.velocity.psi.parsers.ListHandler;
import org.jetbrains.annotations.NotNull;

public class VtlParser
implements PsiParser {
    private static final CompositeBodyParser.CompositeEndDetector EOF_DETECTOR = new CompositeBodyParser.CompositeEndDetector(){

        @Override
        public boolean isCompositeFinished(PsiBuilder builder) {
            return false;
        }
    };
    private static final CompositeBodyParser.CompositeEndDetector DOUBLE_QUOTE_DETECTOR = new CompositeBodyParser.CompositeEndDetector(){

        @Override
        public boolean isCompositeFinished(PsiBuilder builder) {
            return builder.getTokenType() == VtlElementTypes.DOUBLE_QUOTE;
        }
    };

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker rootMarker = builder.mark();
        VtlParser.parseCompositeElements(builder, EOF_DETECTOR);
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/parsers/VtlParser", "parse"));
        }
        return aSTNode;
    }

    static void parseCompositeElements(PsiBuilder builder, CompositeBodyParser.CompositeEndDetector detector) {
        while (!detector.isCompositeFinished(builder) && !builder.eof()) {
            IElementType currentTokenType = builder.getTokenType();
            if (detector.isTokenInvalid(currentTokenType)) {
                builder.error(VelocityBundle.message("invalid.token", builder.getTokenText()));
            }
            if (currentTokenType instanceof VtlCompositeStarterTokenType) {
                VtlParser.parseComposite(builder, (VtlCompositeStarterTokenType)builder.getTokenType());
                continue;
            }
            builder.advanceLexer();
        }
    }

    static void parseComposite(PsiBuilder builder, VtlCompositeStarterTokenType compositeStarter) {
        PsiBuilder.Marker bodyMarker = builder.mark();
        CompositeBodyParser parser = compositeStarter.getCompositeBodyParser();
        builder.advanceLexer();
        parser.parseBody(builder, bodyMarker);
    }

    static void parseList(PsiBuilder builder, ListHandler handler, boolean requireSeparator) {
        boolean firstElement = true;
        while (!handler.isListFinished(builder) && !builder.eof()) {
            if (firstElement) {
                firstElement = false;
            } else if (!handler.parseSeparator(builder) && requireSeparator) {
                builder.error(VelocityBundle.message("token.expected", new Object[]{VtlElementTypes.COMMA}));
            }
            handler.parseListElement(builder);
        }
    }

    static boolean parseBinaryExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!VtlParser.parseRelationalExpression(builder)) {
            expr.drop();
            return false;
        }
        while (VtlElementTypes.LOGICAL_OPERATIONS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            if (!VtlParser.parseRelationalExpression(builder)) {
                builder.error(VelocityBundle.message("expression.expected", new Object[0]));
            }
            expr.done((IElementType)VtlElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private static boolean parseRelationalExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!VtlParser.parseAdditiveExpression(builder)) {
            expr.drop();
            return false;
        }
        while (VtlElementTypes.RELATIONAL_OPERATIONS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            if (!VtlParser.parseAdditiveExpression(builder)) {
                builder.error(VelocityBundle.message("expression.expected", new Object[0]));
            }
            expr.done((IElementType)VtlElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private static boolean parseAdditiveExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!VtlParser.parseMultiplicativeExpression(builder)) {
            expr.drop();
            return false;
        }
        while (VtlElementTypes.ADDITIVE_OPERATIONS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            if (!VtlParser.parseMultiplicativeExpression(builder)) {
                builder.error(VelocityBundle.message("expression.expected", new Object[0]));
            }
            expr.done((IElementType)VtlElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private static boolean parseMultiplicativeExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!VtlParser.parseUnaryExpression(builder)) {
            expr.drop();
            return false;
        }
        while (VtlElementTypes.MULTIPLICATIVE_OPERATIONS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            if (!VtlParser.parseUnaryExpression(builder)) {
                builder.error(VelocityBundle.message("expression.expected", new Object[0]));
            }
            expr.done((IElementType)VtlElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private static boolean parseUnaryExpression(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (VtlElementTypes.UNARY_OPERATIONS.contains(tokenType)) {
            PsiBuilder.Marker expr = builder.mark();
            builder.advanceLexer();
            if (!VtlParser.parseUnaryExpression(builder)) {
                builder.error(VelocityBundle.message("expression.expected", new Object[0]));
            }
            expr.done((IElementType)VtlElementTypes.UNARY_EXPRESSION);
            return true;
        }
        return VtlParser.parseOperand(builder, true);
    }

    static boolean parseOperand(PsiBuilder builder, boolean allowParenthesized) {
        PsiBuilder.Marker expression = builder.mark();
        IElementType elementStarter = builder.getTokenType();
        builder.advanceLexer();
        if (elementStarter == VtlElementTypes.INTEGER) {
            expression.done((IElementType)VtlElementTypes.INTEGER_LITERAL);
        } else if (elementStarter == VtlElementTypes.DOUBLE) {
            expression.done((IElementType)VtlElementTypes.DOUBLE_LITERAL);
        } else if (elementStarter == VtlElementTypes.BOOLEAN) {
            expression.done((IElementType)VtlElementTypes.BOOLEAN_LITERAL);
        } else if (elementStarter == VtlElementTypes.SINGLE_QUOTE) {
            CompositeBodyParser.consumeTokenIfPresent(builder, VtlElementTypes.STRING_TEXT);
            CompositeBodyParser.assertToken(builder, VtlElementTypes.SINGLE_QUOTE);
            expression.done((IElementType)VtlElementTypes.STRING_LITERAL);
        } else if (elementStarter == VtlElementTypes.DOUBLE_QUOTE) {
            if (!CompositeBodyParser.consumeTokenIfPresent(builder, VtlElementTypes.STRING_TEXT)) {
                VtlParser.parseCompositeElements(builder, DOUBLE_QUOTE_DETECTOR);
            }
            CompositeBodyParser.assertToken(builder, VtlElementTypes.DOUBLE_QUOTE);
            expression.done((IElementType)VtlElementTypes.DOUBLEQUOTED_TEXT);
        } else if (elementStarter == VtlElementTypes.START_REFERENCE || elementStarter == VtlElementTypes.START_REF_FORMAL) {
            CompositeBodyParser parser = ((VtlCompositeStarterTokenType)elementStarter).getCompositeBodyParser();
            parser.parseBody(builder, expression);
        } else if (elementStarter == VtlElementTypes.LEFT_BRACKET) {
            VtlParser.parseList(builder, ListHandler.LIST_HANDLER, true);
            CompositeBodyParser.assertToken(builder, VtlElementTypes.RIGHT_BRACKET);
            expression.done((IElementType)VtlElementTypes.LIST_EXPRESSION);
        } else if (allowParenthesized && elementStarter == VtlElementTypes.LEFT_PAREN) {
            VtlParser.parseBinaryExpression(builder);
            CompositeBodyParser.assertToken(builder, VtlElementTypes.RIGHT_PAREN);
            expression.done((IElementType)VtlElementTypes.PARENTHESIZED_EXPRESSION);
        } else if (elementStarter == VtlElementTypes.LEFT_BRACE_IN_EXPR) {
            VtlParser.parseList(builder, ListHandler.MAP_HANDLER, true);
            CompositeBodyParser.assertToken(builder, VtlElementTypes.RIGHT_BRACE_IN_EXPR);
            expression.done((IElementType)VtlElementTypes.MAP_EXPRESSION);
        } else {
            expression.drop();
            builder.error(VelocityBundle.message("operand.expected", new Object[0]));
            return false;
        }
        return true;
    }
}

