/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.graph.beans;

import com.intellij.util.xml.DomElement;
import icons.SeamNavigationIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasicPagesNode<T extends DomElement> {
    private final T myIdentifyingElement;
    private final String myName;

    protected BasicPagesNode(@NotNull T identifyingElement, @Nullable String name) {
        if (identifyingElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifyingElement", "com/intellij/seam/graph/beans/BasicPagesNode", "<init>"));
        }
        this.myIdentifyingElement = identifyingElement;
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public T getIdentifyingElement() {
        T t = this.myIdentifyingElement;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/graph/beans/BasicPagesNode", "getIdentifyingElement"));
        }
        return t;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicPagesNode pagesNode = (BasicPagesNode)o;
        return this.myIdentifyingElement.equals(pagesNode.myIdentifyingElement);
    }

    public int hashCode() {
        int result = this.myIdentifyingElement.hashCode();
        result = 31 * result + (this.myName != null ? this.myName.hashCode() : 0);
        return result;
    }

    public Icon getIcon() {
        return SeamNavigationIcons.Page;
    }
}

