package com.intellij.javaee;

import com.intellij.framework.FrameworkAvailabilityCondition;
import com.intellij.framework.FrameworkVersion;
import org.jetbrains.annotations.NotNull;

/**
 * @author Gregory.Shrago
 */
public enum JavaeeVersion implements FrameworkVersion {
  J2EE_1_4("1.4", "J2EE 1.4"),
  JAVAEE_5("5", "Java EE 5"),
  JAVAEE_6("6", "Java EE 6"),
  JAVAEE_7("7", "Java EE 7");
  private final String myId;
  private final String myPresentableName;

  JavaeeVersion(@NotNull String id, @NotNull String presentableName) {
    myId = id;
    myPresentableName = presentableName;
  }

  @NotNull
  @Override
  public String getId() {
    return myId;
  }

  @NotNull
  @Override
  public String getPresentableName() {
    return myPresentableName;
  }

  @Override
  public String getVersionNumber() {
    return getId();
  }


  @NotNull
  @Override
  public FrameworkAvailabilityCondition getAvailabilityCondition() {
    return FrameworkAvailabilityCondition.ALWAYS_TRUE;
  }
}
