/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.spring;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author Dmitry Avdeev
 */
public interface SpringModelProvider {

  ExtensionPointName<SpringModelProvider> EP_NAME = new ExtensionPointName<SpringModelProvider>("com.intellij.spring.modelProvider");

  /**
   * NOTE: Results *must* be cached as method is called many times from various places.
   *
   * @param facet Facet to get autodetected filesets for.
   * @return Filesets.
   * @see com.intellij.spring.facet.SpringAutodetectedFileSet
   */
  @NotNull
  List<SpringFileSet> getFilesets(@NotNull SpringFacet facet);

  /**
   * Provides human-readable description of this provider.
   *
   * @return Class name.
   * @since 2016.2
   */
  default String getName() {
    return getClass().getSimpleName();
  }
}
