/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.database.model;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.util.KeyedLazyInstance;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.annotations.NotNull;

/**
 * @author gregsh
 */
public interface ModelSerializer {

  ExtensionPointName<KeyedLazyInstance<ModelSerializer>> EP_NAME = ExtensionPointName.create("com.intellij.database.modelSerializer");
  KeyedExtensionCollector<ModelSerializer, String> INSTANCES = new KeyedExtensionCollector<ModelSerializer, String>(EP_NAME.getName());

  @NotNull
  DasModel deserialize(@NotNull HierarchicalStreamReader reader);

  boolean canSerialize(DasModel model);

  void serialize(@NotNull DasModel model, @NotNull HierarchicalStreamWriter writer);
}
