package com.intellij.sql.database;

import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author gregsh
 */
public interface SqlDataSource extends DatabaseSystem {
  @NotNull
  JBIterable<SqlFile> getSqlFiles();
  List<VirtualFile> getFiles();
  List<String> getUrls();

  @Nullable
  DbDataSource getParentDataSource();
}
