/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.highlighting.syntax;

import com.intellij.codeInsight.daemon.impl.analysis.InsertRequiredAttributeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DomAnnotatorVisitor
implements DomElementVisitor {
    private final AnnotationHolder holder;

    protected DomAnnotatorVisitor(AnnotationHolder holder) {
        this.holder = holder;
    }

    public final void visitDomElement(DomElement element) {
        element.acceptChildren((DomElementVisitor)this);
    }

    protected final void checkRequiredAttribute(@NotNull GenericAttributeValue existing, @NotNull GenericAttributeValue required) {
        if (existing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existing", "com/intellij/struts/highlighting/syntax/DomAnnotatorVisitor", "checkRequiredAttribute"));
        }
        if (required == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "required", "com/intellij/struts/highlighting/syntax/DomAnnotatorVisitor", "checkRequiredAttribute"));
        }
        if (existing.getXmlAttribute() != null && required.getXmlAttribute() == null) {
            Annotation annotation = this.holder.createErrorAnnotation((PsiElement)existing.getXmlAttribute(), '\'' + existing.getXmlElementName() + "' specified without '" + required.getXmlElementName() + '\'');
            annotation.registerFix((IntentionAction)new InsertRequiredAttributeFix(existing.getXmlTag(), required.getXmlElementName(), new String[0]));
        }
    }

    protected final void checkMutuallyExclusiveAttributes(GenericAttributeValue ... values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/struts/highlighting/syntax/DomAnnotatorVisitor", "checkMutuallyExclusiveAttributes"));
        }
        int found = 0;
        for (GenericAttributeValue value : values) {
            if (value.getXmlAttribute() == null || ++found <= 1) continue;
            StringBuilder attributeNames = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                attributeNames.append(values[i].getXmlElementName());
                if (i >= values.length - 1) continue;
                attributeNames.append('|');
            }
            this.holder.createErrorAnnotation((PsiElement)value.ensureTagExists(), "Only one of " + attributeNames + " may be specified");
            return;
        }
    }

    protected final void checkDeprecatedAttribute(@NotNull GenericAttributeValue deprecatedAttribute, @NotNull GenericAttributeValue replacementAttribute, @Nullable String replacementValue) {
        if (deprecatedAttribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deprecatedAttribute", "com/intellij/struts/highlighting/syntax/DomAnnotatorVisitor", "checkDeprecatedAttribute"));
        }
        if (replacementAttribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacementAttribute", "com/intellij/struts/highlighting/syntax/DomAnnotatorVisitor", "checkDeprecatedAttribute"));
        }
        if (deprecatedAttribute.getXmlAttribute() != null) {
            Annotation annotation = this.holder.createWarningAnnotation((PsiElement)deprecatedAttribute.getXmlAttribute(), "Deprecated attribute " + deprecatedAttribute.getXmlElementName() + ", use " + replacementAttribute.getXmlElementName() + (replacementValue == null ? "" : "=\"" + replacementValue + "\"") + " instead");
            annotation.setTextAttributes(CodeInsightColors.DEPRECATED_ATTRIBUTES);
            if (replacementAttribute.getXmlAttribute() == null) {
                annotation.registerFix((IntentionAction)new ReplaceDeprecatedAttributeIntentionAction(deprecatedAttribute, replacementAttribute, replacementValue));
            }
        }
    }

    private static class ReplaceDeprecatedAttributeIntentionAction
    extends BaseIntentionAction {
        private final GenericAttributeValue deprecatedAttribute;
        private final GenericAttributeValue replacementAttribute;
        private final String replacementValue;

        ReplaceDeprecatedAttributeIntentionAction(@NotNull GenericAttributeValue deprecatedAttribute, @NotNull GenericAttributeValue replacementAttribute, @Nullable String replacementValue) {
            if (deprecatedAttribute == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deprecatedAttribute", "com/intellij/struts/highlighting/syntax/DomAnnotatorVisitor$ReplaceDeprecatedAttributeIntentionAction", "<init>"));
            }
            if (replacementAttribute == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacementAttribute", "com/intellij/struts/highlighting/syntax/DomAnnotatorVisitor$ReplaceDeprecatedAttributeIntentionAction", "<init>"));
            }
            this.deprecatedAttribute = deprecatedAttribute;
            this.replacementAttribute = replacementAttribute;
            this.replacementValue = replacementValue != null ? replacementValue : ((XmlAttribute)deprecatedAttribute.ensureXmlElementExists()).getValue();
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/highlighting/syntax/DomAnnotatorVisitor$ReplaceDeprecatedAttributeIntentionAction", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getText() {
            if ("Replace deprecated attribute" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/highlighting/syntax/DomAnnotatorVisitor$ReplaceDeprecatedAttributeIntentionAction", "getText"));
            }
            return "Replace deprecated attribute";
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/struts/highlighting/syntax/DomAnnotatorVisitor$ReplaceDeprecatedAttributeIntentionAction", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/struts/highlighting/syntax/DomAnnotatorVisitor$ReplaceDeprecatedAttributeIntentionAction", "invoke"));
            }
            XmlAttribute xmlAttribute = XmlElementFactory.getInstance((Project)project).createXmlAttribute(this.replacementAttribute.getXmlElementName(), this.replacementValue);
            this.deprecatedAttribute.ensureXmlElementExists().replace((PsiElement)xmlAttribute);
        }
    }
}

