/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.klint.client.api.LintClient;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.ResourceXmlDetector;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import com.android.tools.klint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.UastBinaryExpressionWithTypeUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ViewTypeDetector
extends ResourceXmlDetector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("WrongViewCast", "Mismatched view type", "Keeps track of the view types associated with ids and if it finds a usage of the id in the Java code it ensures that it is treated as the same type.", Category.CORRECTNESS, 9, Severity.FATAL, new Implementation(ViewTypeDetector.class, EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.ALL_SOURCE_FILES), Scope.SOURCE_FILE_SCOPE));
    private Boolean mIgnore = null;
    private final Map<String, Object> mIdToViewTag = new HashMap<String, Object>(50);
    private Map<File, Multimap<String, String>> mFileIdMap;

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.SLOW;
    }

    @Override
    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("id");
    }

    @Override
    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        String view = attribute.getOwnerElement().getTagName();
        String value2 = attribute.getValue();
        String id = null;
        if (value2.startsWith("@id/")) {
            id = value2.substring("@id/".length());
        } else if (value2.startsWith("@+id/")) {
            id = value2.substring("@+id/".length());
        }
        if (id != null) {
            List list;
            Object existing;
            if (view.equals("view")) {
                view = attribute.getOwnerElement().getAttribute("class");
            }
            if ((existing = this.mIdToViewTag.get(id)) == null) {
                this.mIdToViewTag.put(id, view);
            } else if (existing instanceof String) {
                String existingString = (String)existing;
                if (!existingString.equals(view)) {
                    ArrayList<String> list2 = new ArrayList<String>(2);
                    list2.add((String)existing);
                    list2.add(view);
                    this.mIdToViewTag.put(id, list2);
                }
            } else if (existing instanceof List && !(list = (List)existing).contains(view)) {
                list.add(view);
            }
        }
    }

    @Override
    public List<String> getApplicableFunctionNames() {
        return Collections.singletonList("findViewById");
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        String id;
        UExpression first;
        JavaContext lintContext = context.getLintContext();
        LintClient client = lintContext.getClient();
        if (this.mIgnore == Boolean.TRUE) {
            return;
        }
        if (this.mIgnore == null) {
            this.mIgnore = !lintContext.getScope().contains((Object)Scope.ALL_RESOURCE_FILES) && !client.supportsProjectResources();
            if (this.mIgnore.booleanValue()) {
                return;
            }
        }
        assert ("findViewById".equals(node.getFunctionName()));
        UBinaryExpressionWithType cast = this.findContainingTypeCast(node.getParent());
        if (cast == null) {
            return;
        }
        String castType = cast.getType().getFqName();
        List<UExpression> args = node.getValueArguments();
        if (args.size() == 1 && (first = args.get(0)) instanceof UQualifiedExpression && UastUtils.startsWithQualified(first, "R.id") && (id = ((UQualifiedExpression)first).getSelectorAsIdentifier()) != null) {
            if (client.supportsProjectResources()) {
                AbstractResourceRepository resources2 = client.getProjectResources(lintContext.getMainProject(), true);
                if (resources2 == null) {
                    return;
                }
                List items = resources2.getResourceItem(ResourceType.ID, id);
                if (items != null && !items.isEmpty()) {
                    HashSet compatible = Sets.newHashSet();
                    for (ResourceItem item : items) {
                        Collection<String> tags = this.getViewTags(lintContext, item);
                        if (tags == null) continue;
                        compatible.addAll(tags);
                    }
                    if (!compatible.isEmpty()) {
                        ArrayList layoutTypes = Lists.newArrayList((Iterable)compatible);
                        ViewTypeDetector.checkCompatible(lintContext, castType, null, layoutTypes, cast);
                    }
                }
            } else {
                Object types2 = this.mIdToViewTag.get(id);
                if (types2 instanceof String) {
                    String layoutType = (String)types2;
                    ViewTypeDetector.checkCompatible(lintContext, castType, layoutType, null, cast);
                } else if (types2 instanceof List) {
                    List layoutTypes = (List)types2;
                    ViewTypeDetector.checkCompatible(lintContext, castType, null, layoutTypes, cast);
                }
            }
        }
    }

    private UBinaryExpressionWithType findContainingTypeCast(UElement expression2) {
        if (expression2 == null) {
            return null;
        }
        if (UastBinaryExpressionWithTypeUtils.isTypeCast(expression2)) {
            return (UBinaryExpressionWithType)expression2;
        }
        if (expression2 instanceof UQualifiedExpression) {
            UElement parent = expression2.getParent();
            if (expression2.equals(expression2.getParent())) {
                return null;
            }
            return this.findContainingTypeCast(parent);
        }
        if (expression2 instanceof UParenthesizedExpression) {
            return this.findContainingTypeCast(expression2.getParent());
        }
        return null;
    }

    @Nullable
    protected Collection<String> getViewTags(@NonNull Context context, @NonNull ResourceItem item) {
        File file;
        Multimap<String, String> map2;
        ResourceFile source = (ResourceFile)item.getSource();
        if (source != null && (map2 = this.getIdToTagsIn(context, file = source.getFile())) != null) {
            return map2.get((Object)item.getName());
        }
        return null;
    }

    @Nullable
    private Multimap<String, String> getIdToTagsIn(@NonNull Context context, @NonNull File file) {
        ArrayListMultimap map2;
        if (!file.getPath().endsWith(".xml")) {
            return null;
        }
        if (this.mFileIdMap == null) {
            this.mFileIdMap = Maps.newHashMap();
        }
        if ((map2 = this.mFileIdMap.get(file)) == null) {
            map2 = ArrayListMultimap.create();
            this.mFileIdMap.put(file, (Multimap<String, String>)map2);
            String xml = context.getClient().readFile(file);
            Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
            if (document != null && document.getDocumentElement() != null) {
                ViewTypeDetector.addViewTags((Multimap<String, String>)map2, document.getDocumentElement());
            }
        }
        return map2;
    }

    private static void addViewTags(Multimap<String, String> map2, Element element) {
        String id = element.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
        if (id != null && !id.isEmpty() && !map2.containsEntry((Object)(id = LintUtils.stripIdPrefix(id)), (Object)element.getTagName())) {
            map2.put((Object)id, (Object)element.getTagName());
        }
        NodeList children = element.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            ViewTypeDetector.addViewTags(map2, (Element)child);
        }
    }

    private static void checkCompatible(JavaContext context, String castType, String layoutType, List<String> layoutTypes, UBinaryExpressionWithType node) {
        boolean compatible;
        block6: {
            block5: {
                assert (layoutType == null || layoutTypes == null);
                compatible = true;
                if (layoutType == null) break block5;
                if (layoutType.equals(castType) || context.getSdkInfo().isSubViewOf(castType, layoutType)) break block6;
                compatible = false;
                break block6;
            }
            compatible = false;
            assert (layoutTypes != null);
            for (String type2 : layoutTypes) {
                if (!type2.equals(castType) && !context.getSdkInfo().isSubViewOf(castType, type2)) continue;
                compatible = true;
                break;
            }
        }
        if (!compatible) {
            if (layoutType == null) {
                layoutType = Joiner.on((String)"|").join(layoutTypes);
            }
            String message2 = String.format("Unexpected cast to `%1$s`: layout tag was `%2$s`", castType, layoutType);
            context.report(ISSUE, node, context.getLocation(node), message2);
        }
    }
}

