/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.gridpane.GridPaneMosaic;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractNodeHandles;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.ResizeColumnGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.ResizeRowGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.SelectAndMoveInGridGesture;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import java.util.Collections;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;

public class GridPaneHandles
extends AbstractNodeHandles<GridPane> {
    private final GridPaneMosaic mosaic = new GridPaneMosaic("handles", true, true);

    public GridPaneHandles(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController, fxomInstance, GridPane.class);
        this.getRootNode().getChildren().add(0, (Object)this.mosaic.getTopGroup());
    }

    public void updateColumnRowSelection(GridSelectionGroup gsg) {
        if (gsg == null) {
            this.mosaic.setSelectedColumnIndexes(Collections.emptySet());
            this.mosaic.setSelectedRowIndexes(Collections.emptySet());
        } else {
            switch (gsg.getType()) {
                case COLUMN: {
                    this.mosaic.setSelectedColumnIndexes(gsg.getIndexes());
                    this.mosaic.setSelectedRowIndexes(Collections.emptySet());
                    break;
                }
                case ROW: {
                    this.mosaic.setSelectedColumnIndexes(Collections.emptySet());
                    this.mosaic.setSelectedRowIndexes(gsg.getIndexes());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    @Override
    public void layoutDecoration() {
        super.layoutDecoration();
        if (this.mosaic.getGridPane() != this.getSceneGraphObject()) {
            this.mosaic.setGridPane((GridPane)this.getSceneGraphObject());
        } else {
            this.mosaic.update();
        }
        for (Node node : this.mosaic.getNorthTrayNodes()) {
            this.attachHandles(node);
        }
        for (Node node : this.mosaic.getSouthTrayNodes()) {
            this.attachHandles(node);
        }
        for (Node node : this.mosaic.getEastTrayNodes()) {
            this.attachHandles(node);
        }
        for (Node node : this.mosaic.getWestTrayNodes()) {
            this.attachHandles(node);
        }
        for (Node node : this.mosaic.getHgapSensorNodes()) {
            this.attachHandles(node);
        }
        for (Node node : this.mosaic.getVgapSensorNodes()) {
            this.attachHandles(node);
        }
        this.mosaic.getTopGroup().getTransforms().clear();
        this.mosaic.getTopGroup().getTransforms().add((Object)this.getSceneGraphObjectToDecorationTransform());
    }

    @Override
    public AbstractGesture findGesture(Node node) {
        AbstractGesture result = this.findGestureInTrays(node);
        if (result == null) {
            result = this.findGestureInSensors(node);
        }
        return result;
    }

    private AbstractGesture findGestureInTrays(Node node) {
        GridSelectionGroup.Type feature;
        int trayIndex = this.mosaic.getNorthTrayNodes().indexOf(node);
        if (trayIndex != -1) {
            feature = GridSelectionGroup.Type.COLUMN;
        } else {
            trayIndex = this.mosaic.getSouthTrayNodes().indexOf(node);
            if (trayIndex != -1) {
                feature = GridSelectionGroup.Type.COLUMN;
            } else {
                trayIndex = this.mosaic.getWestTrayNodes().indexOf(node);
                if (trayIndex != -1) {
                    feature = GridSelectionGroup.Type.ROW;
                } else {
                    trayIndex = this.mosaic.getEastTrayNodes().indexOf(node);
                    feature = GridSelectionGroup.Type.ROW;
                }
            }
        }
        AbstractGesture result = trayIndex == -1 ? super.findGesture(node) : new SelectAndMoveInGridGesture(this.getContentPanelController(), this.getFxomInstance(), feature, trayIndex);
        return result;
    }

    private AbstractGesture findGestureInSensors(Node node) {
        int sensorIndex = this.mosaic.getHgapSensorNodes().indexOf(node);
        AbstractGesture result = sensorIndex != -1 ? new ResizeColumnGesture(this, sensorIndex) : ((sensorIndex = this.mosaic.getVgapSensorNodes().indexOf(node)) != -1 ? new ResizeRowGesture(this, sensorIndex) : super.findGesture(node));
        return result;
    }

    private void attachHandles(Node node) {
        if (AbstractHandles.lookupHandles(node) == null) {
            GridPaneHandles.attachHandles(node, this);
        }
    }
}

