/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.PathMappingProvider;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublishConfigMappingProvider
extends PathMappingProvider {
    @NotNull
    public String getProviderPresentableName(@NotNull RemoteSdkAdditionalData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider", "getProviderPresentableName"));
        }
        final Ref name = new Ref();
        data.switchOnConnectionType(new CredentialsCase[]{new CredentialsCase.Ssh(){

            public void process(RemoteCredentialsHolder credentials) {
                name.set((Object)"SFTP Deployment configurations");
            }
        }, new CredentialsCase.WebDeployment(){

            public void process(WebDeploymentCredentialsHolder cred) {
                name.set((Object)("'" + cred.getWebServerConfigName() + "' Deployment configuration"));
            }
        }});
        String string = (String)name.get();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider", "getProviderPresentableName"));
        }
        return string;
    }

    public boolean accepts(@Nullable RemoteSdkAdditionalData data) {
        return data != null && (data.connectionCredentials().getRemoteConnectionType() == CredentialsType.WEB_DEPLOYMENT || data.connectionCredentials().getRemoteConnectionType() == CredentialsType.SSH_HOST);
    }

    @NotNull
    public PathMappingSettings getPathMappingSettings(final @NotNull Project project, final @NotNull RemoteSdkAdditionalData data) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider", "getPathMappingSettings"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider", "getPathMappingSettings"));
        }
        final PathMappingSettings mappingSettings = new PathMappingSettings();
        data.switchOnConnectionType(new CredentialsCase[]{new CredentialsCase.Ssh(){

            public void process(RemoteCredentialsHolder cred) {
                try {
                    RemoteSdkCredentials credentials = data.getRemoteSdkCredentials(project, false);
                    mappingSettings.addAll(PublishConfigMappingProvider.getPathMappingsForDeploymentConfigurations(project, (RemoteCredentials)credentials));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, new CredentialsCase.WebDeployment(){

            public void process(WebDeploymentCredentialsHolder cred) {
                PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
                for (WebServerConfig webConfig : RemoteSdkUtil.getSftpServerList(project)) {
                    if (cred.getWebServerConfigId() == null || !cred.getWebServerConfigId().equals(webConfig.getId())) continue;
                    PublishConfigMappingProvider.addMappings(webConfig, publishConfig, mappingSettings);
                }
            }
        }});
        PathMappingSettings pathMappingSettings = mappingSettings;
        if (pathMappingSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider", "getPathMappingSettings"));
        }
        return pathMappingSettings;
    }

    private static void addMappings(WebServerConfig webConfig, PublishConfig publishConfig, PathMappingSettings mappingSettings) {
        List mappings = publishConfig.getPathMappings(webConfig.getId());
        for (DeploymentPathMapping mapping : mappings) {
            String rootFolder = webConfig.getFileTransferConfig().getRootFolder();
            rootFolder = rootFolder.replaceAll("\\\\", "/").trim();
            rootFolder = StringUtil.trimEnd((String)rootFolder, (String)"/");
            if (StringUtil.isEmpty((String)mapping.getLocalPath()) || StringUtil.isEmpty((String)mapping.getDeployPath())) continue;
            mappingSettings.addMapping(mapping.getLocalPath(), rootFolder + mapping.getDeployPath());
        }
    }

    public static PathMappingSettings getPathMappingsForDeploymentConfigurations(Project project, RemoteCredentials data) {
        PathMappingSettings mappingSettings = new PathMappingSettings();
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        for (WebServerConfig webConfig : RemoteSdkUtil.getSftpServerList(project)) {
            if (!StringUtil.equals((CharSequence)PublishConfigMappingProvider.normalizeHost(webConfig.getFileTransferConfig().getHost()), (CharSequence)PublishConfigMappingProvider.normalizeHost(data.getHost()))) continue;
            PublishConfigMappingProvider.addMappings(webConfig, publishConfig, mappingSettings);
        }
        return mappingSettings;
    }

    public static String getDeploymentConfigurationWithMappingsName(Project project, RemoteCredentials data) {
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        for (WebServerConfig webConfig : RemoteSdkUtil.getSftpServerList(project)) {
            DeploymentPathMapping mapping;
            List mappings = publishConfig.getPathMappings(webConfig.getId());
            if (mappings.isEmpty()) continue;
            boolean mappingsNotEmpty = false;
            Iterator iterator = mappings.iterator();
            while (iterator.hasNext() && !(mappingsNotEmpty = !StringUtil.isEmptyOrSpaces((String)(mapping = (DeploymentPathMapping)iterator.next()).getLocalPath()) && !StringUtil.isEmptyOrSpaces((String)mapping.getDeployPath()))) {
            }
            if (!mappingsNotEmpty || !StringUtil.equals((CharSequence)PublishConfigMappingProvider.normalizeHost(webConfig.getFileTransferConfig().getHost()), (CharSequence)PublishConfigMappingProvider.normalizeHost(data.getHost()))) continue;
            return webConfig.getName();
        }
        return null;
    }

    @Nullable
    private static CharSequence normalizeHost(@Nullable String host) {
        if ("localhost".equals(host)) {
            return "127.0.0.1";
        }
        return host;
    }
}

