/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.tools;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SchemeElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.remote.ColoredRemoteProcessHandler;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsBuilder;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolProcessAdapter;
import com.intellij.tools.ToolsBundle;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.console.RemoteDataProducer;
import com.jetbrains.plugins.remotesdk.tools.RemoteToolRunProfile;
import com.jetbrains.plugins.remotesdk.transport.JschProcess;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionManager;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteTool
extends Tool {
    @NonNls
    public static final String ACTION_ID_PREFIX = "RemoteTool_";
    @Nullable
    private RemoteConnectionType myConnectionType;
    private String myConnectionId;

    public void copyFrom(Tool source) {
        super.copyFrom(source);
        if (source instanceof RemoteTool) {
            RemoteTool remoteTool = (RemoteTool)source;
            this.myConnectionType = remoteTool.getConnectionType();
            this.myConnectionId = remoteTool.getConnectionId();
        }
    }

    @NotNull
    public SchemeElement copy() {
        RemoteTool copy = new RemoteTool();
        copy.copyFrom(this);
        RemoteTool remoteTool = copy;
        if (remoteTool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/tools/RemoteTool", "copy"));
        }
        return remoteTool;
    }

    public void execute(@Nullable AnActionEvent event, DataContext dataContext, long executionId, @Nullable ProcessListener processListener) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        FileDocumentManager.getInstance().saveAllDocuments();
        this.getRemoteSdkData(event, project, module, (Consumer<RemoteCredentials>)((Consumer)data -> UIUtil.invokeLaterIfNeeded(() -> {
            try {
                if (this.isUseConsole()) {
                    this.executeRemoteToolProfile((RemoteCredentials)data, dataContext, project, executionId, processListener);
                } else {
                    GeneralCommandLine commandLine = this.createCommandLine(dataContext);
                    if (commandLine == null) {
                        return;
                    }
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        try {
                            this.startRemoteProcess(project, (RemoteCredentials)data, commandLine, processListener);
                        }
                        catch (ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
            }
            catch (ExecutionException ee) {
                ExecutionErrorDialog.show((ExecutionException)ee, (String)ToolsBundle.message((String)"tools.process.start.error", (Object[])new Object[0]), (Project)project);
            }
            catch (Exception ex) {
                ExecutionException ee = ex.getCause() instanceof ExecutionException ? (ExecutionException)ex.getCause() : new ExecutionException((Throwable)ex);
                ExecutionErrorDialog.show((ExecutionException)ee, (String)ToolsBundle.message((String)"tools.process.start.error", (Object[])new Object[0]), (Project)project);
            }
        })));
    }

    private void executeRemoteToolProfile(RemoteCredentials data, DataContext dataContext, Project project, long executionId, final @Nullable ProcessListener processListener) throws ExecutionException {
        RemoteToolRunProfile profile = new RemoteToolRunProfile(this, data, dataContext);
        ProgramRunner runner = RunnerRegistry.getInstance().getRunner(DefaultRunExecutor.EXECUTOR_ID, (RunProfile)profile);
        assert (runner != null);
        ExecutionEnvironment environment = new ExecutionEnvironmentBuilder(project, DefaultRunExecutor.getRunExecutorInstance()).runProfile((RunProfile)profile).build();
        environment.setExecutionId(executionId);
        runner.execute(environment, new ProgramRunner.Callback(){

            public void processStarted(RunContentDescriptor descriptor) {
                ProcessHandler processHandler = descriptor.getProcessHandler();
                if (processHandler != null && processListener != null) {
                    processHandler.addProcessListener(processListener);
                }
            }
        });
    }

    private void startRemoteProcess(Project project, RemoteCredentials data, GeneralCommandLine commandLine, @Nullable ProcessListener processListener) throws ExecutionException {
        try {
            SshRemoteSession runProcessSession = SshConnectionManager.getInstance().getSession(project, data);
            RemoteSdkCredentials sdkData = new RemoteSdkCredentialsBuilder().withCredentials(data).build();
            JschProcess process = RemoteSdkUtil.createRemoteProcess(runProcessSession, sdkData, commandLine, true, false, true);
            ColoredRemoteProcessHandler handler = new ColoredRemoteProcessHandler((RemoteProcess)process, commandLine.getCommandLineString(), EncodingProjectManager.getInstance((Project)project).getDefaultCharset());
            handler.addProcessListener((ProcessListener)new ToolProcessAdapter(project, this.synchronizeAfterExecution(), this.getName()));
            if (processListener != null) {
                handler.addProcessListener(processListener);
            }
            handler.startNotify();
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutionException("Cant execute remote external tool", (Throwable)e);
        }
    }

    @Nullable
    public RemoteConnectionType getConnectionType() {
        return this.myConnectionType;
    }

    public String getConnectionId() {
        return this.myConnectionId;
    }

    public void setConnectionType(@Nullable RemoteConnectionType connectionType) {
        this.myConnectionType = connectionType;
    }

    public void setConnectionId(String connectionId) {
        this.myConnectionId = connectionId;
    }

    public void getRemoteSdkData(@Nullable AnActionEvent event, Project project, Module module, Consumer<RemoteCredentials> consumer) {
        if (event != null) {
            new RemoteDataProducer().withActionEvent(event).produceRemoteData(this.getConnectionType(), this.getConnectionId(), consumer);
        } else {
            new RemoteDataProducer().withProject(project).withModule(module).produceRemoteData(this.getConnectionType(), this.getConnectionId(), consumer);
        }
    }

    public String getActionIdPrefix() {
        return ACTION_ID_PREFIX;
    }
}

