/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.tools;

import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.remote.RemoteCredentials;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolEditorDialog;
import com.intellij.util.AsyncProducer;
import com.intellij.util.Consumer;
import com.jetbrains.plugins.remotesdk.console.RemoteConnectionSettingsForm;
import com.jetbrains.plugins.remotesdk.console.RemoteDataProducer;
import com.jetbrains.plugins.remotesdk.tools.RemoteTool;
import com.jetbrains.plugins.remotesdk.ui.RemoteBrowseActionListener;
import java.awt.GridBagConstraints;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class RemoteToolEditorDialog
extends ToolEditorDialog {
    private RemoteConnectionSettingsForm myConnectionSettingsForm;

    RemoteToolEditorDialog(JComponent parent, String title) {
        super(parent, title);
    }

    @NotNull
    protected JPanel createCenterPanel() {
        JPanel panel = super.createCenterPanel();
        this.myConnectionSettingsForm = new RemoteConnectionSettingsForm(null, this.myDisposable);
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridwidth = 4;
        constr.fill = 1;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.anchor = 11;
        panel.add(this.myConnectionSettingsForm.createPanel(), constr, 7);
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/tools/RemoteToolEditorDialog", "createCenterPanel"));
        }
        return jPanel;
    }

    protected RemoteTool createTool() {
        return new RemoteTool();
    }

    public RemoteTool getData() {
        RemoteTool tool = (RemoteTool)super.getData();
        tool.setConnectionId(this.myConnectionSettingsForm.getConnectionId());
        tool.setConnectionType(this.myConnectionSettingsForm.getConnectionType());
        return tool;
    }

    protected void setData(Tool tool, String[] existingGroups) {
        super.setData(tool, existingGroups);
        if (tool instanceof RemoteTool) {
            RemoteTool remoteTool = (RemoteTool)tool;
            this.myConnectionSettingsForm.setConnectionTypeAndId(remoteTool.getConnectionType(), remoteTool.getConnectionId());
        }
    }

    protected void addWorkingDirectoryBrowseAction(JPanel pane, FixedSizeButton button, JTextField textField) {
        button.addActionListener((ActionListener)new RemoteBrowseActionListener(textField, "Select working directory on the remote host", this.createRemoteDataProducer()).withFoldersOnly(true));
    }

    private AsyncProducer<RemoteCredentials> createRemoteDataProducer() {
        return consumer -> new RemoteDataProducer().withComponentOwner(this.getContentPanel()).produceRemoteData(this.myConnectionSettingsForm.getConnectionType(), this.myConnectionSettingsForm.getConnectionId(), (Consumer<RemoteCredentials>)consumer);
    }

    protected void addCommandBrowseAction(JPanel pane, FixedSizeButton button, JTextField textField) {
        button.addActionListener((ActionListener)new RemoteBrowseActionListener(textField, "Select executable on the remote host", this.createRemoteDataProducer()).withFoldersOnly(false));
    }

    protected String getIdForHelpAction() {
        return "reference.settings.remote.ssh.ext.tools.create.tool";
    }
}

