/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.execution.ExecutionException;
import com.intellij.idea.RareLogger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteMappingsListener;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CaseCollector;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.ui.MappingsGatherer;
import com.jetbrains.plugins.remotesdk.ui.RemoteMappingsConfiguration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteMappingsHolder {
    private static final Logger LOG = RareLogger.wrap((Logger)Logger.getInstance((String)"#com.jetbrains.plugins.remotesdk.ui.RemoteMappingsHolder"), (boolean)false);
    @NotNull
    protected final Project myProject;
    protected final String myInterpreterKindPrefix;
    @NotNull
    protected final Consumer<String> myErrorConsumer;
    @Nullable
    protected RemoteSdkAdditionalData mySdkAdditionalData;
    protected RemoteMappingsConfiguration.Builder myBuilder;
    @Nullable
    protected String myServerId;

    public RemoteMappingsHolder(@NotNull Project project, String interpreterKindPrefix, @NotNull Consumer<String> errorConsumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsHolder", "<init>"));
        }
        if (errorConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorConsumer", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsHolder", "<init>"));
        }
        this.myProject = project;
        this.myInterpreterKindPrefix = interpreterKindPrefix;
        this.myErrorConsumer = errorConsumer;
    }

    protected void addMappingsFromProducers() throws ExecutionException {
        try {
            CredentialsType connectionType = this.mySdkAdditionalData.getRemoteConnectionType();
            if (!CaseCollector.useRemoteCredentials((RemoteSdkAdditionalData)this.mySdkAdditionalData)) {
                return;
            }
            List<PathMappingSettings.PathMapping> list = new MappingsGatherer(this.myProject, this.mySdkAdditionalData, this.myInterpreterKindPrefix).addUserDefined(false).addDisabled(true).assemble();
            if (list.isEmpty()) {
                return;
            }
            if (connectionType == CredentialsType.VAGRANT) {
                this.myBuilder.withMappings(RemoteMappingsConfiguration.MappingType.REPLICATED_FOLDER, list);
            } else if (connectionType == CredentialsType.SSH_HOST || connectionType == CredentialsType.WEB_DEPLOYMENT) {
                this.myBuilder.withMappings(RemoteMappingsConfiguration.MappingType.DEPLOYMENT, list);
            }
        }
        catch (InterruptedException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    @NotNull
    public JComponent getDescriptionComponent(@NotNull String serverId) {
        if (serverId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverId", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsHolder", "getDescriptionComponent"));
        }
        JEditorPane jEditorPane = SwingHelper.createHtmlLabel((String)("<font style=\"color:#" + Integer.toHexString(UIUtil.getInactiveTextColor().getRGB()).substring(2) + "\">Project path mappings for all usages of the selected interpreter</font>"), null, null);
        if (jEditorPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsHolder", "getDescriptionComponent"));
        }
        return jEditorPane;
    }

    public void clearAndShowDisabled(@Nullable String fieldText, @Nullable String problemText) {
        this.myServerId = null;
        this.mySdkAdditionalData = null;
        this.setVisible(true);
        this.setEnabled(false);
        this.updatePresentation(StringUtil.notNullize((String)fieldText));
        this.setToolTipText(problemText);
        this.myErrorConsumer.consume((Object)problemText);
    }

    public void updateServerId(@NotNull String serverId, @NotNull RemoteSdkAdditionalData sdkAdditionalData) {
        if (serverId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverId", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsHolder", "updateServerId"));
        }
        if (sdkAdditionalData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkAdditionalData", "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsHolder", "updateServerId"));
        }
        this.myServerId = serverId;
        this.mySdkAdditionalData = sdkAdditionalData;
        this.myErrorConsumer.consume(null);
        this.setEnabled(true);
        this.setVisible(this.myServerId != null && this.mySdkAdditionalData != null);
        this.myBuilder = new RemoteMappingsConfiguration.Builder(this.myProject, this.myInterpreterKindPrefix, this.myServerId, this.mySdkAdditionalData);
        try {
            this.myBuilder.withDescriptionComponent(this.getDescriptionComponent(this.myServerId));
            this.addMappingsFromProducers();
            this.updatePresentation(this.myBuilder.getPresentation());
            this.setToolTipText(this.myBuilder.getTooltipText());
        }
        catch (ExecutionException e) {
            LOG.info((Throwable)e);
            this.clearAndShowDisabled(e.getMessage(), e.getMessage());
        }
    }

    protected abstract void setToolTipText(String var1);

    protected abstract void setVisible(boolean var1);

    protected abstract void setEnabled(boolean var1);

    protected abstract void updatePresentation(@Nullable String var1);

    protected abstract String getPresentation();

    public void editPathMappings() {
        if (this.myServerId == null || this.mySdkAdditionalData == null || this.myBuilder == null) {
            return;
        }
        this.myErrorConsumer.consume(null);
        String value = this.getPresentation();
        try {
            value = this.myBuilder.configureAndSelect();
            if (value != null) {
                this.updateServerId(this.myServerId, this.mySdkAdditionalData);
                this.updatePresentation(value);
                ((RemoteMappingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(RemoteMappingsListener.REMOTE_MAPPINGS_CHANGED)).mappingsChanged(this.myInterpreterKindPrefix, this.myServerId);
            }
        }
        catch (ExecutionException e1) {
            LOG.info((Throwable)e1);
            this.clearAndShowDisabled(value, e1.getMessage());
        }
    }
}

