/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.calls;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CalleeMethodsTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.hierarchy.calls.CalleeReferenceVisitorBase;
import org.jetbrains.kotlin.idea.hierarchy.calls.KotlinCallHierarchyNodeDescriptor;
import org.jetbrains.kotlin.idea.hierarchy.calls.KotlinCallTreeStructure;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

public class KotlinCalleeMethodsTreeStructure
extends KotlinCallTreeStructure {
    private final CalleeMethodsTreeStructure javaTreeStructure;
    private final PsiClass representativePsiClass;

    public KotlinCalleeMethodsTreeStructure(@NotNull Project project, @NotNull PsiElement element2, String scopeType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCalleeMethodsTreeStructure", "<init>"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCalleeMethodsTreeStructure", "<init>"));
        }
        super(project, element2, scopeType);
        PsiMethod representativePsiMethod = KotlinCalleeMethodsTreeStructure.getRepresentativePsiMethod(element2);
        assert (representativePsiMethod != null);
        this.representativePsiClass = representativePsiMethod.getContainingClass();
        this.javaTreeStructure = new CalleeMethodsTreeStructure(project, representativePsiMethod, scopeType);
    }

    private static Map<PsiReference, PsiElement> getReferencesToCalleeElements(@NotNull KtElement rootElement) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCalleeMethodsTreeStructure", "getReferencesToCalleeElements"));
        }
        ArrayList<KtElement> elementsToAnalyze = new ArrayList<KtElement>();
        if (rootElement instanceof KtNamedFunction) {
            elementsToAnalyze.add(((KtNamedFunction)rootElement).getBodyExpression());
        } else if (rootElement instanceof KtProperty) {
            for (KtPropertyAccessor ktPropertyAccessor : ((KtProperty)rootElement).getAccessors()) {
                KtExpression ktExpression = ktPropertyAccessor.getBodyExpression();
                if (ktExpression == null) continue;
                elementsToAnalyze.add(ktExpression);
            }
        } else {
            KtClassOrObject classOrObject = (KtClassOrObject)rootElement;
            for (KtSuperTypeListEntry ktSuperTypeListEntry : classOrObject.getSuperTypeListEntries()) {
                if (!(ktSuperTypeListEntry instanceof KtCallElement)) continue;
                elementsToAnalyze.add(ktSuperTypeListEntry);
            }
            KtClassBody ktClassBody = classOrObject.getBody();
            if (ktClassBody != null) {
                for (KtAnonymousInitializer initializer2 : ktClassBody.getAnonymousInitializers()) {
                    KtExpression initializerBody = initializer2.getBody();
                    if (initializerBody == null) continue;
                    elementsToAnalyze.add(initializerBody);
                }
                for (KtProperty property2 : ktClassBody.getProperties()) {
                    KtExpression initializer3 = property2.getInitializer();
                    if (initializer3 == null) continue;
                    elementsToAnalyze.add(initializer3);
                }
            }
        }
        final HashMap<PsiReference, PsiElement> referencesToCalleeElements = new HashMap<PsiReference, PsiElement>();
        for (KtElement ktElement : elementsToAnalyze) {
            ktElement.accept(new CalleeReferenceVisitorBase(ResolutionUtils.analyze(ktElement, BodyResolveMode.FULL), false){

                @Override
                protected void processDeclaration(KtSimpleNameExpression reference2, PsiElement declaration) {
                    referencesToCalleeElements.put(ReferenceUtilKt.getMainReference(reference2), declaration);
                }
            });
        }
        return referencesToCalleeElements;
    }

    @NotNull
    protected Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor2) {
        PsiMethod psiMethod;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCalleeMethodsTreeStructure", "buildChildren"));
        }
        PsiElement targetElement = KotlinCalleeMethodsTreeStructure.getTargetElement(descriptor2);
        if (targetElement instanceof PsiMethod && (psiMethod = (PsiMethod)targetElement).isConstructor()) {
            PsiElement navigationElement;
            PsiClass psiClass = psiMethod.getContainingClass();
            PsiElement psiElement = navigationElement = psiClass != null ? psiClass.getNavigationElement() : null;
            if (navigationElement instanceof KtClass) {
                Object[] objectArray = this.buildChildrenByKotlinTarget(descriptor2, (KtElement)navigationElement);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCalleeMethodsTreeStructure", "buildChildren"));
                }
                return objectArray;
            }
        }
        if (targetElement instanceof KtLightMethod) {
            Object[] objectArray = this.buildChildrenByKotlinTarget(descriptor2, ((KtLightMethod)targetElement).getKotlinOrigin());
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCalleeMethodsTreeStructure", "buildChildren"));
            }
            return objectArray;
        }
        if (targetElement instanceof KtElement) {
            Object[] objectArray = this.buildChildrenByKotlinTarget(descriptor2, (KtElement)targetElement);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCalleeMethodsTreeStructure", "buildChildren"));
            }
            return objectArray;
        }
        CallHierarchyNodeDescriptor javaDescriptor = descriptor2 instanceof CallHierarchyNodeDescriptor ? (CallHierarchyNodeDescriptor)descriptor2 : ((KotlinCallHierarchyNodeDescriptor)descriptor2).getJavaDelegate();
        Object[] objectArray = this.javaTreeStructure.getChildElements((Object)javaDescriptor);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCalleeMethodsTreeStructure", "buildChildren"));
        }
        return objectArray;
    }

    private Object[] buildChildrenByKotlinTarget(HierarchyNodeDescriptor descriptor2, KtElement targetElement) {
        Map<PsiReference, PsiElement> referencesToCalleeElements = KotlinCalleeMethodsTreeStructure.getReferencesToCalleeElements(targetElement);
        return this.collectNodeDescriptors(descriptor2, referencesToCalleeElements, this.representativePsiClass);
    }
}

