/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.javaee.oss.glassfish.server.GlassfishIntegration;
import com.intellij.javaee.oss.glassfish.server.GlassfishRemoteModel;
import com.intellij.javaee.oss.server.JavaeeRunSettingsEditor;
import com.intellij.javaee.oss.transport.SimpleRemoteServerModel;
import com.intellij.javaee.oss.transport.SimpleRemoteStagingEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class GlassfishRemoteEditor
extends JavaeeRunSettingsEditor<GlassfishRemoteModel> {
    @NonNls
    private static final String DOMAIN_CARD_NAME = "Domain";
    @NonNls
    private static final String CLUSTER_CARD_NAME = "Cluster";
    private JPanel panel;
    private JTextField port;
    private JTextField username;
    private JPasswordField password;
    private JCheckBox preserve;
    private JCheckBox myUploadWithGlassfishCheckBox;
    private JCheckBox mySecuredCheckBox;
    private SimpleRemoteStagingEditor myRemoteStagingEditor;
    private JTextField myVirtualServerTextField;
    private JRadioButton myDomainRadioButton;
    private JRadioButton myClusterRadioButton;
    private JPanel myServerLaunchPanel;
    private JTextField myClusterNameTextField;
    private JTextField myDomainAdminServerHost;
    private JPanel myDeploymentMethodPanel;
    private JCheckBox myCompatibilityCheckBox;

    public GlassfishRemoteEditor() {
        super(GlassfishIntegration.getInstance());
        this.$$$setupUI$$$();
        ActionListener radioListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlassfishRemoteEditor.this.updateDeployTarget();
            }
        };
        this.myDomainRadioButton.addActionListener(radioListener);
        this.myClusterRadioButton.addActionListener(radioListener);
        this.myUploadWithGlassfishCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlassfishRemoteEditor.this.updateEnablement();
            }
        });
        this.updateEnablement();
    }

    private void updateDeployTarget() {
        String cardName = this.myDomainRadioButton.isSelected() ? DOMAIN_CARD_NAME : CLUSTER_CARD_NAME;
        ((CardLayout)this.myServerLaunchPanel.getLayout()).show(this.myServerLaunchPanel, cardName);
    }

    private void updateEnablement() {
        UIUtil.setEnabled((Component)this.myRemoteStagingEditor.getMainPanel(), (!this.myUploadWithGlassfishCheckBox.isSelected() ? 1 : 0) != 0, (boolean)true);
    }

    @NotNull
    protected JComponent getEditor() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/glassfish/server/GlassfishRemoteEditor", "getEditor"));
        }
        return jPanel;
    }

    protected void resetEditorFrom(GlassfishRemoteModel model) {
        this.port.setText(String.valueOf(model.ADMIN_PORT));
        this.username.setText(model.USERNAME);
        this.password.setText(model.PASSWORD);
        this.preserve.setEnabled(model.isGlassfish3Plus());
        this.preserve.setSelected(model.PRESERVE);
        this.myCompatibilityCheckBox.setEnabled(model.isGlassfish3Plus());
        this.myCompatibilityCheckBox.setSelected(model.COMPATIBILITY);
        this.myUploadWithGlassfishCheckBox.setSelected(model.isUploadWithGlassfish());
        this.mySecuredCheckBox.setSelected(model.isSecured());
        this.myVirtualServerTextField.setText(StringUtil.notNullize((String)model.VIRTUAL_SERVER));
        boolean isClusterSupported = model.isClusterSupported();
        this.myDeploymentMethodPanel.setVisible(isClusterSupported);
        JRadioButton radioButton = isClusterSupported && model.DEPLOY_ON_CLUSTER ? this.myClusterRadioButton : this.myDomainRadioButton;
        radioButton.doClick();
        this.myClusterNameTextField.setText(model.CLUSTER_NAME);
        this.myDomainAdminServerHost.setText(model.ADMIN_SERVER_HOST);
        this.myRemoteStagingEditor.resetEditorFrom((SimpleRemoteServerModel)model);
        this.updateEnablement();
    }

    protected void applyEditorTo(GlassfishRemoteModel model) throws ConfigurationException {
        int adminPort;
        try {
            adminPort = Integer.parseInt(this.port.getText());
        }
        catch (NumberFormatException e) {
            adminPort = GlassfishRemoteModel.DEFAULT_ADMIN_PORT;
        }
        model.ADMIN_PORT = adminPort;
        model.USERNAME = this.username.getText();
        model.PASSWORD = new String(this.password.getPassword());
        model.PRESERVE = this.preserve.isSelected();
        model.COMPATIBILITY = this.myCompatibilityCheckBox.isSelected();
        model.setUploadWithGlassfish(this.myUploadWithGlassfishCheckBox.isSelected());
        model.setSecured(this.mySecuredCheckBox.isSelected());
        model.VIRTUAL_SERVER = StringUtil.nullize((String)this.myVirtualServerTextField.getText().trim());
        model.DEPLOY_ON_CLUSTER = this.myClusterRadioButton.isSelected();
        model.CLUSTER_NAME = this.myClusterNameTextField.getText();
        model.ADMIN_SERVER_HOST = this.myDomainAdminServerHost.getText();
        this.myRemoteStagingEditor.applyEditorTo((SimpleRemoteServerModel)model);
    }

    private void createUIComponents() {
        this.myRemoteStagingEditor = new SimpleRemoteStagingEditor();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JPasswordField jPasswordField;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JTextField jTextField4;
        JTextField jTextField5;
        JPanel jPanel3;
        this.createUIComponents();
        this.panel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(11, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("resources/glassfish").getString("GlassfishRemoteEditor.port"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.port = jTextField5 = new JTextField();
        jTextField5.setColumns(4);
        jPanel3.add((Component)jTextField5, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("resources/javaee").getString("RunEditor.username"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.username = jTextField4 = new JTextField();
        jPanel3.add((Component)jTextField4, new GridConstraints(1, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(150, -1), null));
        this.preserve = jCheckBox4 = new JCheckBox();
        ((Component)jCheckBox4).setVisible(true);
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("resources/glassfish").getString("GlassfishEditor.preserve"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(6, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(10, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myUploadWithGlassfishCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("resources/glassfish").getString("GlassfishRemoteEditor.upload"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(8, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        SimpleRemoteStagingEditor simpleRemoteStagingEditor = this.myRemoteStagingEditor;
        JComponent jComponent = simpleRemoteStagingEditor.$$$getRootComponent$$$();
        jPanel3.add((Component)jComponent, new GridConstraints(9, 0, 1, 3, 1, 1, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("resources/javaee").getString("RunEditor.password"));
        jPanel3.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.password = jPasswordField = new JPasswordField();
        jPanel3.add((Component)jPasswordField, new GridConstraints(2, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(150, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySecuredCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Use SSL connection");
        jPanel3.add((Component)jCheckBox2, new GridConstraints(5, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myDeploymentMethodPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myDomainRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("resources/glassfish").getString("GlassfishRemoteEditor.radio.domain"));
        jRadioButton2.setSelected(true);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myClusterRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("resources/glassfish").getString("GlassfishRemoteEditor.radio.cluster"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("resources/glassfish").getString("GlassfishRemoteEditor.deploy.target"));
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myServerLaunchPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, DOMAIN_CARD_NAME);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Virtual server:");
        jPanel4.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(1, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myVirtualServerTextField = jTextField3 = new JTextField();
        jPanel4.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, CLUSTER_CARD_NAME);
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("resources/glassfish").getString("GlassfishRemoteEditor.cluster.name"));
        jPanel5.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("resources/glassfish").getString("GlassfishRemoteEditor.host"));
        jPanel5.add((Component)jLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClusterNameTextField = jTextField2 = new JTextField();
        jPanel5.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDomainAdminServerHost = jTextField = new JTextField();
        jPanel5.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCompatibilityCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("resources/glassfish").getString("GlassfishEditor.compatibility"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(7, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField5);
        jLabel2.setLabelFor(jTextField4);
        jLabel3.setLabelFor(jPasswordField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

