/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.actions;

import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.JavaCreateTemplateInPackageAction;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.psi.util.AjFileTemplateUtil;
import com.intellij.lang.aspectj.util.LibraryUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import icons.AspectjIcons;
import org.jetbrains.annotations.NotNull;

public class CreateAspectAction
extends JavaCreateTemplateInPackageAction<PsiClass> {
    public CreateAspectAction() {
        super("", AspectJBundle.message("action.create.aspect.description", new Object[0]), AspectjIcons.Aspect, true);
    }

    protected PsiElement getNavigationElement(@NotNull PsiClass createdElement) {
        if (createdElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createdElement", "com/intellij/lang/aspectj/actions/CreateAspectAction", "getNavigationElement"));
        }
        return createdElement;
    }

    protected void buildDialog(Project project, PsiDirectory directory, CreateFileFromTemplateDialog.Builder builder) {
        builder.setTitle(AspectJBundle.message("action.create.aspect.name", new Object[0])).addKind("Aspect", AspectjIcons.Aspect, "Aspect.aj").addKind("@Aspect", PlatformIcons.CLASS_ICON, "@Aspect.java");
    }

    protected boolean isAvailable(DataContext dataContext) {
        return super.isAvailable(dataContext) && LibraryUtil.hasAjRunTime((Module)LangDataKeys.MODULE.getData(dataContext));
    }

    protected PsiClass doCreate(PsiDirectory dir, String className, String templateName) throws IncorrectOperationException {
        if (templateName.endsWith(".aj")) {
            return AjFileTemplateUtil.createAspectFromTemplate(dir, className, templateName);
        }
        return JavaDirectoryService.getInstance().createClass(dir, className, templateName, true);
    }

    protected String getActionName(PsiDirectory directory, String newName, String templateName) {
        String packageName;
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (aPackage != null && !StringUtil.isEmptyOrSpaces((String)(packageName = aPackage.getName()))) {
            newName = aPackage.getQualifiedName() + "." + newName;
        }
        return AspectJBundle.message("action.create.aspect.title", newName);
    }

    protected String getErrorTitle() {
        return AspectJBundle.message("action.create.aspect.error", new Object[0]);
    }
}

