/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.util.ModuleUtils;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFileManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + ConfigFileManager.class.getName()));
    private final Module myModule;

    public ConfigFileManager(Module module) {
        this.myModule = module;
    }

    private String getFileName() {
        return this.myModule.getName();
    }

    private String getFileNameWithExt() {
        return this.getFileName() + ".properties";
    }

    private VirtualFile getConfigFileDirectory(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/dmserver/artifacts/ConfigFileManager", "getConfigFileDirectory"));
        }
        return ModuleUtils.getModuleRoot(rootModel);
    }

    public VirtualFile findConfigFile() {
        VirtualFile configFileDirectory = this.getConfigFileDirectory((ModuleRootModel)ModuleRootManager.getInstance((Module)this.myModule));
        if (configFileDirectory == null) {
            return null;
        }
        return configFileDirectory.findChild(this.getFileNameWithExt());
    }

    @Nullable
    public VirtualFile createConfigFile(final @NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/dmserver/artifacts/ConfigFileManager", "createConfigFile"));
        }
        RunResult result = new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/dmserver/artifacts/ConfigFileManager$1", "run"));
                }
                result.setResult((Object)ConfigFileManager.this.doCreateConfigFile(rootModel));
            }
        }.executeSilently();
        result.logException(LOG);
        return (VirtualFile)result.getResultObject();
    }

    private VirtualFile doCreateConfigFile(@NotNull ModuleRootModel rootModel) throws IOException {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/dmserver/artifacts/ConfigFileManager", "doCreateConfigFile"));
        }
        VirtualFile configFileDirectory = this.getConfigFileDirectory(rootModel);
        VirtualFile result = configFileDirectory.findChild(this.getFileNameWithExt());
        if (result == null) {
            result = configFileDirectory.createChildData((Object)this, this.getFileNameWithExt());
        }
        return result;
    }
}

