/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.artifacts.DMArtifactTypeBase;
import com.intellij.dmserver.artifacts.DMCompositeArtifactTypeBase;
import com.intellij.dmserver.artifacts.DMCompositePackagingElement;
import com.intellij.dmserver.artifacts.ManifestManager;
import com.intellij.dmserver.facet.DMCompositeFacet;
import com.intellij.dmserver.facet.DMCompositeFacetConfiguration;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.util.containers.ContainerUtil;
import icons.DmServerSupportIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DMParArtifactType
extends DMCompositeArtifactTypeBase {
    @NonNls
    private static final String ARTIFACT_ID_DM_PAR = "dm.par";
    @NonNls
    public static final String PAR_EXTENSION = "par";
    private static final VirtualFileFilter PAR_FILE_FILTER = new DMArtifactTypeBase.ByExtensionFilter("par");

    public static DMParArtifactType getInstance() {
        return (DMParArtifactType)((Object)ContainerUtil.findInstance((Object[])DMParArtifactType.getAllTypes(), DMParArtifactType.class));
    }

    public DMParArtifactType() {
        super(ARTIFACT_ID_DM_PAR, DmServerBundle.message("DMParArtifactType.display.name", new Object[0]), false);
    }

    @Override
    @NotNull
    protected VirtualFileFilter getMainFileToDeployFilter(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/artifacts/DMParArtifactType", "getMainFileToDeployFilter"));
        }
        VirtualFileFilter virtualFileFilter = PAR_FILE_FILTER;
        if (virtualFileFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/DMParArtifactType", "getMainFileToDeployFilter"));
        }
        return virtualFileFilter;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = DmServerSupportIcons.Par_bundle;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/DMParArtifactType", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public CompositePackagingElement<?> createRootElement(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/intellij/dmserver/artifacts/DMParArtifactType", "createRootElement"));
        }
        CompositePackagingElement compositePackagingElement = PackagingElementFactory.getInstance().createArchive("");
        if (compositePackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/DMParArtifactType", "createRootElement"));
        }
        return compositePackagingElement;
    }

    @Override
    public Artifact createArtifactFor(@NotNull Module module, @NotNull DMCompositeFacet facet) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/DMParArtifactType", "createArtifactFor"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/dmserver/artifacts/DMParArtifactType", "createArtifactFor"));
        }
        Project project = module.getProject();
        ArtifactManager manager = ArtifactManager.getInstance((Project)project);
        Artifact artifact = manager.addArtifact("dm PAR for '" + module.getName() + "'", (ArtifactType)this, null);
        ArchivePackagingElement root = (ArchivePackagingElement)artifact.getRootElement();
        root.setArchiveFileName(module.getName() + "." + PAR_EXTENSION);
        DMCompositePackagingElement compositePackaging = (DMCompositePackagingElement)((Object)this.addOrFindModuleReference((CompositePackagingElement<?>)root, module));
        this.addNestedBundlesReferences(module, compositePackaging, facet);
        return artifact;
    }

    @Override
    public void synchronizeArtifact(@NotNull Artifact artifact, @NotNull Module module, @NotNull DMCompositeFacet facet) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/artifacts/DMParArtifactType", "synchronizeArtifact"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/DMParArtifactType", "synchronizeArtifact"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/dmserver/artifacts/DMParArtifactType", "synchronizeArtifact"));
        }
        if (!this.isCompatibleArtifact(artifact)) {
            throw new IllegalArgumentException("I am not compatible with artifact: " + artifact);
        }
        DMCompositePackagingElement compositePackaging = (DMCompositePackagingElement)((Object)this.addOrFindModuleReference(artifact.getRootElement(), module));
        this.synchronizeNestedBundlesReferences(module, compositePackaging, facet);
    }

    @Override
    public void updateModuleSupport(@NotNull Module module, @NotNull DMCompositeFacet facet, @NotNull ModuleRootModel rootModel, @NotNull DMCompositeFacetConfiguration facetConfiguration) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/DMParArtifactType", "updateModuleSupport"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/dmserver/artifacts/DMParArtifactType", "updateModuleSupport"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/dmserver/artifacts/DMParArtifactType", "updateModuleSupport"));
        }
        if (facetConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetConfiguration", "com/intellij/dmserver/artifacts/DMParArtifactType", "updateModuleSupport"));
        }
        ManifestManager.getParInstance().createManifest(module, module, rootModel, facetConfiguration.getName(module), facetConfiguration.getVersion());
    }
}

