/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.install;

import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.install.DMServerInstallationManager;
import com.intellij.dmserver.install.impl.DMServerInstallationImpl;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMServerInstallationEditor {
    @Nullable
    private Project myProject;
    private ComboboxWithBrowseButton myFolderSelector;

    public DMServerInstallationEditor(@Nullable Project project, boolean checkInstallation) {
        this.myProject = project;
        this.myFolderSelector = new ComboboxWithBrowseButton();
        this.myFolderSelector.addBrowseFolderListener(project, (ComponentWithBrowseButton.BrowseFolderActionListener)new DMServerInstallationChecker(project, this.myFolderSelector, checkInstallation));
        JComboBox comboBox = this.myFolderSelector.getComboBox();
        comboBox.setEditable(true);
        comboBox.removeAllItems();
        for (DMServerInstallation dMServerInstallation : DMServerInstallationManager.getInstance().getValidInstallations()) {
            comboBox.addItem(FileUtil.toSystemDependentName((String)dMServerInstallation.getHome().getPath()));
        }
    }

    public JComponent getJComponent() {
        return this.myFolderSelector;
    }

    public String getPath() {
        return FileUtil.toSystemIndependentName((String)((String)this.myFolderSelector.getComboBox().getEditor().getItem()));
    }

    public void setPath(String path) {
        this.myFolderSelector.getComboBox().setSelectedItem(path != null ? FileUtil.toSystemDependentName((String)path) : null);
    }

    public void setDefaultPath() {
        JComboBox comboBox = this.myFolderSelector.getComboBox();
        if (comboBox.getItemCount() > 0) {
            comboBox.setSelectedIndex(0);
        }
    }

    public JComboBox getComboBox() {
        return this.myFolderSelector.getComboBox();
    }

    private static class DMServerInstallationChecker
    extends ComponentWithBrowseButton.BrowseFolderActionListener<JComboBox> {
        private final ComboboxWithBrowseButton myPathEditor;
        private final boolean myCheckInstallation;

        public DMServerInstallationChecker(@Nullable Project project, ComboboxWithBrowseButton pathEditor, boolean checkInstallation) {
            super(DmServerBundle.message("DMServerInstallationChecker.browse.name", new Object[0]), DmServerBundle.message("DMServerInstallationChecker.browse.description", new Object[0]), (ComponentWithBrowseButton)pathEditor, project, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT);
            this.myPathEditor = pathEditor;
            this.myCheckInstallation = checkInstallation;
        }

        protected void onFileChosen(@NotNull VirtualFile chosenFile) {
            ValidationResult result;
            if (chosenFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/dmserver/install/DMServerInstallationEditor$DMServerInstallationChecker", "onFileChosen"));
            }
            super.onFileChosen(chosenFile);
            if (this.myCheckInstallation && !(result = new DMServerInstallationImpl(chosenFile).validate()).isOk()) {
                Messages.showErrorDialog((Component)this.myPathEditor, (String)result.getErrorMessage());
            }
        }
    }
}

