/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.psi.searchers;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafResolveUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class ThymeleafMethodReferenceSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public ThymeleafMethodReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters parameters, @NotNull Processor<PsiReference> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/thymeleaf/lang/psi/searchers/ThymeleafMethodReferenceSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/thymeleaf/lang/psi/searchers/ThymeleafMethodReferenceSearcher", "processQuery"));
        }
        SearchScope effectiveSearchScope = parameters.getEffectiveSearchScope();
        if (effectiveSearchScope instanceof GlobalSearchScope) {
            effectiveSearchScope = ThymeleafResolveUtil.getThymeleafFilesScope(parameters.getMethod().getProject(), (GlobalSearchScope)effectiveSearchScope);
        }
        ThymeleafMethodReferenceSearcher.searchMethod(effectiveSearchScope, parameters.getOptimizer(), parameters.getMethod());
    }

    public static void searchMethod(@NotNull SearchScope scope, @NotNull SearchRequestCollector optimizer, @NotNull PsiMethod method) {
        String propName;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/thymeleaf/lang/psi/searchers/ThymeleafMethodReferenceSearcher", "searchMethod"));
        }
        if (optimizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optimizer", "com/intellij/thymeleaf/lang/psi/searchers/ThymeleafMethodReferenceSearcher", "searchMethod"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/thymeleaf/lang/psi/searchers/ThymeleafMethodReferenceSearcher", "searchMethod"));
        }
        if (PropertyUtil.isSimplePropertyGetter((PsiMethod)method) && !StringUtil.isEmpty((String)(propName = PropertyUtil.getPropertyNameByGetter((PsiMethod)method)))) {
            optimizer.searchWord(propName, scope, (short)8, true, (PsiElement)method);
        }
        optimizer.searchWord(method.getName(), scope, (short)8, true, (PsiElement)method);
    }
}

