/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.support.processors;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.thymeleaf.lang.psi.ThymeleafReference;
import com.intellij.thymeleaf.lang.psi.ThymesELMethodCallExpression;
import com.intellij.thymeleaf.lang.support.ThymeleafElementProcessor;
import com.intellij.util.containers.hash.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MultiResolveProcessor
extends ThymeleafElementProcessor {
    @NotNull
    private final String myHintName;
    private ThymesELMethodCallExpression myMethodResolve;
    @NotNull
    private final Set<ResolveResult> myResults;

    public MultiResolveProcessor(@NotNull ThymeleafReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/thymeleaf/lang/support/processors/MultiResolveProcessor", "<init>"));
        }
        this.myResults = new HashSet();
        this.myHintName = reference.getText();
        PsiElement element = reference.getElement();
        ThymesELMethodCallExpression methodCallExpression = (ThymesELMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, ThymesELMethodCallExpression.class);
        if (methodCallExpression != null && element.equals(methodCallExpression.getMethod())) {
            this.myMethodResolve = methodCallExpression;
        }
    }

    @NotNull
    public ResolveResult[] getResults() {
        ResolveResult[] resolveResultArray = this.myResults.toArray(new ResolveResult[this.myResults.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/processors/MultiResolveProcessor", "getResults"));
        }
        return resolveResultArray;
    }

    @Override
    public boolean processVariable(@NotNull PsiVariable variable, @NotNull PsiSubstitutor substitutor) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/thymeleaf/lang/support/processors/MultiResolveProcessor", "processVariable"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/thymeleaf/lang/support/processors/MultiResolveProcessor", "processVariable"));
        }
        if (!this.isMethodResolve() && variable.getName().equals(this.myHintName)) {
            this.myResults.add((ResolveResult)new CandidateInfo((PsiElement)variable, substitutor));
        }
        return true;
    }

    protected boolean isMethodResolve() {
        return this.myMethodResolve != null;
    }

    @Override
    public boolean processMethod(@NotNull PsiMethod psiMethod, @NotNull PsiSubstitutor substitutor) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/thymeleaf/lang/support/processors/MultiResolveProcessor", "processMethod"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/thymeleaf/lang/support/processors/MultiResolveProcessor", "processMethod"));
        }
        if (this.isMethodResolve()) {
            if (psiMethod.getName().equals(this.myHintName) && this.myMethodResolve.getParameterList().getElExpressionList().size() == psiMethod.getParameterList().getParametersCount()) {
                this.myResults.add((ResolveResult)new CandidateInfo((PsiElement)psiMethod, substitutor));
            }
        } else if (this.myHintName.equals(PropertyUtil.getPropertyNameByGetter((PsiMethod)psiMethod)) || this.myHintName.equals(psiMethod.getName()) && psiMethod.getParameterList().getParametersCount() == 0) {
            this.myResults.add((ResolveResult)new CandidateInfo((PsiElement)psiMethod, substitutor));
        }
        return true;
    }

    @Override
    public boolean processPackage(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/thymeleaf/lang/support/processors/MultiResolveProcessor", "processPackage"));
        }
        if (this.myHintName.equals(psiPackage.getName())) {
            this.myResults.add((ResolveResult)new CandidateInfo((PsiElement)psiPackage, PsiSubstitutor.EMPTY));
        }
        return true;
    }

    @Override
    public boolean processClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/thymeleaf/lang/support/processors/MultiResolveProcessor", "processClass"));
        }
        if (this.myHintName.equals(psiClass.getName())) {
            this.myResults.add((ResolveResult)new CandidateInfo((PsiElement)psiClass, PsiSubstitutor.EMPTY));
        }
        return true;
    }
}

