/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.diagram.beans.wrappers;

import com.intellij.jboss.jbpm.diagram.beans.wrappers.BpmnElementWrapper;
import com.intellij.jboss.jbpm.model.BpmnDomModel;
import com.intellij.jboss.jbpm.model.BpmnDomModelManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmnModuleWrapper
extends BpmnElementWrapper<Module> {
    public BpmnModuleWrapper(@NotNull Module element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jboss/jbpm/diagram/beans/wrappers/BpmnModuleWrapper", "<init>"));
        }
        super(element);
    }

    @Override
    @NotNull
    public String getName() {
        String string = "Module " + ((Module)this.myElement).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/diagram/beans/wrappers/BpmnModuleWrapper", "getName"));
        }
        return string;
    }

    @Override
    public String getFqn() {
        return ((Module)this.myElement).getName();
    }

    @Override
    @NotNull
    public List<BpmnDomModel> getBpmnModels() {
        List<BpmnDomModel> list = BpmnDomModelManager.getInstance(((Module)this.myElement).getProject()).getAllModels((Module)this.myElement);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/diagram/beans/wrappers/BpmnModuleWrapper", "getBpmnModels"));
        }
        return list;
    }

    @Nullable
    public static BpmnElementWrapper resolveElementByFQN(String fqn, Project project) {
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(fqn);
        if (module == null) {
            return null;
        }
        return new BpmnModuleWrapper(module);
    }
}

