/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.MavenIcons;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenEnvironmentForm;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenArchetypesStep;
import org.jetbrains.idea.maven.wizards.MavenModuleBuilderHelper;
import org.jetbrains.idea.maven.wizards.MavenModuleWizardStep;
import org.jetbrains.idea.maven.wizards.SelectPropertiesStep;

public class MavenModuleBuilder
extends ModuleBuilder
implements SourcePathsBuilder {
    private MavenProject myAggregatorProject;
    private MavenProject myParentProject;
    private boolean myInheritGroupId;
    private boolean myInheritVersion;
    private MavenId myProjectId;
    private MavenArchetype myArchetype;
    private MavenEnvironmentForm myEnvironmentForm;
    private Map<String, String> myPropertiesToCreateByArtifact;

    public void setupRootModel(ModifiableRootModel rootModel) throws ConfigurationException {
        final Project project = rootModel.getProject();
        final VirtualFile root = this.createAndGetContentEntry();
        rootModel.addContentEntry(root);
        if (this.myJdk != null) {
            rootModel.setSdk(this.myJdk);
        } else {
            rootModel.inheritSdk();
        }
        MavenUtil.runWhenInitialized(project, (Runnable)new DumbAwareRunnable(){

            public void run() {
                if (MavenModuleBuilder.this.myEnvironmentForm != null) {
                    MavenModuleBuilder.this.myEnvironmentForm.setData(MavenProjectsManager.getInstance(project).getGeneralSettings());
                }
                new MavenModuleBuilderHelper(MavenModuleBuilder.this.myProjectId, MavenModuleBuilder.this.myAggregatorProject, MavenModuleBuilder.this.myParentProject, MavenModuleBuilder.this.myInheritGroupId, MavenModuleBuilder.this.myInheritVersion, MavenModuleBuilder.this.myArchetype, MavenModuleBuilder.this.myPropertiesToCreateByArtifact, "Create new Maven module").configure(project, root, false);
            }
        });
    }

    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPresentableName() {
        return "Maven";
    }

    public String getParentGroup() {
        return "Build Tools";
    }

    public int getWeight() {
        return 80;
    }

    public String getDescription() {
        return "Maven modules are used for developing <b>JVM-based</b> applications with dependencies managed by <b>Maven</b>. You can create either a blank Maven module or a module based on a <b>Maven archetype</b>.";
    }

    public Icon getBigIcon() {
        return AllIcons.Modules.Types.JavaModule;
    }

    public Icon getNodeIcon() {
        return MavenIcons.MavenLogo;
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk == JavaSdk.getInstance();
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardContext", "org/jetbrains/idea/maven/wizards/MavenModuleBuilder", "createWizardSteps"));
        }
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "org/jetbrains/idea/maven/wizards/MavenModuleBuilder", "createWizardSteps"));
        }
        return new ModuleWizardStep[]{new MavenModuleWizardStep(this, wizardContext, !wizardContext.isNewWizard()), new SelectPropertiesStep(wizardContext.getProject(), this)};
    }

    private VirtualFile createAndGetContentEntry() {
        String path = FileUtil.toSystemIndependentName((String)this.getContentEntryPath());
        new File(path).mkdirs();
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
    }

    public List<Pair<String, String>> getSourcePaths() {
        return Collections.emptyList();
    }

    public void setSourcePaths(List<Pair<String, String>> sourcePaths) {
    }

    public void addSourcePath(Pair<String, String> sourcePathInfo) {
    }

    public void setAggregatorProject(MavenProject project) {
        this.myAggregatorProject = project;
    }

    public MavenProject getAggregatorProject() {
        return this.myAggregatorProject;
    }

    public void setParentProject(MavenProject project) {
        this.myParentProject = project;
    }

    public MavenProject getParentProject() {
        return this.myParentProject;
    }

    public void setInheritedOptions(boolean groupId, boolean version) {
        this.myInheritGroupId = groupId;
        this.myInheritVersion = version;
    }

    public boolean isInheritGroupId() {
        return this.myInheritGroupId;
    }

    public boolean isInheritVersion() {
        return this.myInheritVersion;
    }

    public void setProjectId(MavenId id) {
        this.myProjectId = id;
    }

    public MavenId getProjectId() {
        return this.myProjectId;
    }

    public void setArchetype(MavenArchetype archetype) {
        this.myArchetype = archetype;
    }

    public MavenArchetype getArchetype() {
        return this.myArchetype;
    }

    public MavenEnvironmentForm getEnvironmentForm() {
        return this.myEnvironmentForm;
    }

    public void setEnvironmentForm(MavenEnvironmentForm environmentForm) {
        this.myEnvironmentForm = environmentForm;
    }

    public Map<String, String> getPropertiesToCreateByArtifact() {
        return this.myPropertiesToCreateByArtifact;
    }

    public void setPropertiesToCreateByArtifact(Map<String, String> propertiesToCreateByArtifact) {
        this.myPropertiesToCreateByArtifact = propertiesToCreateByArtifact;
    }

    public String getGroupName() {
        return "Maven";
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        MavenArchetypesStep step = new MavenArchetypesStep(this, null);
        Disposer.register((Disposable)parentDisposable, (Disposable)step);
        return step;
    }
}

