/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.configuration;

import com.intellij.j2ee.webSphere.applicationServer.WebSphereIntegration;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersion;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeeServerHomeProvider;
import com.intellij.javaee.oss.server.JavaeeServerVersionConfig;
import com.intellij.javaee.oss.server.JavaeeServerVersionDescriptor;
import com.intellij.javaee.oss.util.Version;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileReader;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebSphereVersionUtil
extends JavaeeServerVersionConfig {
    public static final int V6_DEFAULT_SOAP_PORT = 8880;
    public static final int V5_DEFAULT_SOAP_PORT = 7880;
    public static final int V6_DEFAULT_HTTP_PORT = 9080;
    public static final int V5_DEFAULT_HTTP_PORT = 7080;
    @NonNls
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    @NonNls
    private static final String PROFILES_DIR = "profiles";
    @NonNls
    private static final String LIB_DIR = "lib";
    @NonNls
    private static final String J2EE_JAR_NAME = "j2ee.jar";
    @NonNls
    private static final String PLATFORM_WEBSPHERE_FILE_PATH = "properties" + File.separator + "version" + File.separator + "platform.websphere";
    @NonNls
    private static final String LIBERTY_PROFILE_PROPERTIES_PATH = FileUtil.toSystemDependentName((String)"lib/versions/WebSphereApplicationServer.properties");
    @NonNls
    private static final String LIBERTY_PROFILE_VERSION_PROPERTY = "com.ibm.websphere.productVersion";
    private static final JavaeeServerVersionConfig.Factory<JavaeePersistentData> ourFactory = new JavaeeServerVersionConfig.Factory<JavaeePersistentData>(){

        @NotNull
        public WebSphereVersionUtil createConfig(JavaeePersistentData data) {
            WebSphereVersionUtil webSphereVersionUtil = new WebSphereVersionUtil();
            if (webSphereVersionUtil == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/configuration/WebSphereVersionUtil$1", "createConfig"));
            }
            return webSphereVersionUtil;
        }
    };

    private WebSphereVersionUtil() {
    }

    public static String get(JavaeePersistentData persistentData) throws Exception {
        return WebSphereVersionUtil.get(ourFactory, (JavaeePersistentData)persistentData);
    }

    @Nullable
    public static WebSphereVersion createVersion(ApplicationServer applicationServer) {
        if (applicationServer == null) {
            return null;
        }
        File serverHome = new File(new JavaeeServerHomeProvider(applicationServer).getValue());
        JavaeePersistentData persistentData = (JavaeePersistentData)applicationServer.getPersistentData();
        return WebSphereVersionUtil.createVersion(serverHome, persistentData);
    }

    @Nullable
    public static WebSphereVersion createVersion(File serverHome, JavaeePersistentData persistentData) {
        if (!serverHome.exists()) {
            return null;
        }
        Version version = new Version(WebSphereIntegration.getInstance().getServerVersionSilently(persistentData));
        WebSphereVersionDescriptor descriptor = WebSphereVersionUtil.getDescriptor(version);
        if (descriptor == null) {
            return null;
        }
        boolean libertyProfile = new File(serverHome, LIBERTY_PROFILE_PROPERTIES_PATH).exists();
        return new WebSphereVersion(serverHome, version.getMajor() + "." + version.getMinor(), descriptor.myProfilesSupported, descriptor.myDefaultSOAPPort, descriptor.myDefaultHttpPort, libertyProfile ? null : new File(serverHome, PROFILES_DIR), libertyProfile ? null : new File(new File(serverHome, LIB_DIR), J2EE_JAR_NAME), !libertyProfile && descriptor.myProfilesSupported, descriptor.myProfilesSupported, descriptor.myJspPackage, !descriptor.myProfilesSupported, descriptor.myUseIbmAlgorithm, !descriptor.myUseIbmAlgorithm, libertyProfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaeeServerVersionDescriptor getVersionDescriptor(String home) throws Exception {
        File platformPropertiesFile = new File(home, PLATFORM_WEBSPHERE_FILE_PATH);
        if (platformPropertiesFile.exists()) {
            String version = JDOMUtil.load((File)platformPropertiesFile).getAttributeValue(VERSION_ATTRIBUTE_NAME);
            return new JavaeeServerVersionDescriptor(version, platformPropertiesFile);
        }
        File libertyProfilePropertiesFile = new File(home, LIBERTY_PROFILE_PROPERTIES_PATH);
        Properties properties = new Properties();
        try (FileReader propertiesReader = new FileReader(libertyProfilePropertiesFile);){
            properties.load(propertiesReader);
            String version = properties.getProperty(LIBERTY_PROFILE_VERSION_PROPERTY);
            JavaeeServerVersionDescriptor javaeeServerVersionDescriptor = new JavaeeServerVersionDescriptor(version, libertyProfilePropertiesFile);
            return javaeeServerVersionDescriptor;
        }
    }

    @Nullable
    private static WebSphereVersionDescriptor getDescriptor(Version version) {
        if (version.getMajor() == 5) {
            return WebSphereVersionDescriptor.V5x;
        }
        if (version.getMajor() == 6 && version.getMinor() == 0) {
            return WebSphereVersionDescriptor.V6;
        }
        if (version.getMajor() == 6 && version.getMinor() == 1 || version.getMajor() >= 7) {
            return WebSphereVersionDescriptor.V61Plus;
        }
        return null;
    }

    public static enum WebSphereVersionDescriptor {
        V5x(7880, 7080, "org.apache.jsp", false, false),
        V6(8880, 9080, "com.ibm._jsp", true, false),
        V61Plus(8880, 9080, "com.ibm._jsp", true, true);

        private final int myDefaultSOAPPort;
        private final int myDefaultHttpPort;
        private final String myJspPackage;
        private final boolean myProfilesSupported;
        private final boolean myUseIbmAlgorithm;

        private WebSphereVersionDescriptor(@NonNls int defaultSOAPPort, int defaultHttpPort, String jspPackage, boolean profilesSupported, boolean useIbmAlgorithm) {
            this.myDefaultSOAPPort = defaultSOAPPort;
            this.myDefaultHttpPort = defaultHttpPort;
            this.myJspPackage = jspPackage;
            this.myProfilesSupported = profilesSupported;
            this.myUseIbmAlgorithm = useIbmAlgorithm;
        }
    }
}

