/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.lang.completion;

import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.model.presentation.TapestryParameter;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ResolvedValue;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ValueResolverChain;
import com.intellij.tapestry.core.util.ClassUtils;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryXmlExtension;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Scanner;
import java.util.Set;

public class ParameterValueContextGetter
implements ContextGetter {
    private static final Logger _logger = Logger.getInstance(ParameterValueContextGetter.class);

    public Object[] get(PsiElement psiElement, CompletionContext completionContext) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)psiElement);
        if (!TapestryUtils.isTapestryModule(module)) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        if (psiElement instanceof XmlToken && ((XmlToken)psiElement).getTokenType().toString().equals("XML_ATTRIBUTE_VALUE_TOKEN")) {
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlAttribute.class);
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class);
            if (attribute == null) {
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            if (TapestryXmlExtension.isTapestryTemplateNamespace(attribute.getNamespace()) && (attribute.getLocalName().equals("type") || attribute.getLocalName().equals("id") || attribute.getLocalName().equals("mixins"))) {
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            Component component = TapestryUtils.getTypeOfTag(tag);
            if (component == null) {
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            TapestryProject tapestryProject = TapestryModuleSupportLoader.getTapestryProject(module);
            if (tapestryProject == null) {
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            PresentationLibraryElement element = tapestryProject.findElementByTemplate(completionContext.file);
            if (element == null) {
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            IntellijJavaClassType elementClass = (IntellijJavaClassType)element.getElementClass();
            if (elementClass == null) {
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            for (TapestryParameter parameter : component.getParameters().values()) {
                String attributeValue = "";
                if (tag != null) {
                    attributeValue = tag.getAttributeValue(attribute.getLocalName());
                }
                if (!parameter.getName().equalsIgnoreCase(attribute.getLocalName())) continue;
                if (attributeValue != null) {
                    if (attributeValue.equals("prop:IntellijIdeaRulezzz ")) {
                        Set<String> properties = ClassUtils.getClassProperties(elementClass).keySet();
                        ArrayList<String> returnedProperties = new ArrayList<String>();
                        for (String property : properties) {
                            returnedProperties.add("prop:" + property);
                        }
                        return returnedProperties.toArray();
                    }
                    if (attributeValue.contains(".") && !attributeValue.contains("..") && (parameter.getDefaultPrefix().equals("prop") || attributeValue.startsWith("prop:"))) {
                        ResolvedValue resolvedValue;
                        if (attributeValue.contains(".IntellijIdeaRulezzz ")) {
                            Scanner scan = new Scanner(attributeValue);
                            String word = "";
                            String words = "";
                            while (scan.hasNext() && !word.contains("IntellijIdeaRulezzz")) {
                                word = scan.next();
                                words = words + word;
                            }
                            attributeValue = words.replaceFirst("IntellijIdeaRulezzz", "");
                        }
                        try {
                            resolvedValue = ValueResolverChain.getInstance().resolve(tapestryProject, elementClass, attributeValue, parameter.getDefaultPrefix());
                        }
                        catch (Exception ex) {
                            _logger.error((Throwable)ex);
                            return ArrayUtil.EMPTY_OBJECT_ARRAY;
                        }
                        if (resolvedValue != null && resolvedValue.getType() != null && resolvedValue.getType() instanceof IJavaClassType) {
                            elementClass = new IntellijJavaClassType(module, ((IntellijJavaClassType)resolvedValue.getType()).getPsiClass().getContainingFile());
                            Set<String> properties = ClassUtils.getClassProperties(elementClass).keySet();
                            ArrayList<String> returnedProperties = new ArrayList<String>();
                            for (String property : properties) {
                                returnedProperties.add(attributeValue + "" + property);
                            }
                            return returnedProperties.toArray();
                        }
                    }
                }
                if (parameter.getParameterField().getType() != null && parameter.getParameterField().getType().getName().toLowerCase(Locale.getDefault()).equals("boolean")) {
                    HashSet<String> attributes = new HashSet<String>(ClassUtils.getClassProperties(elementClass).keySet());
                    attributes.add("literal:true");
                    attributes.add("literal:false");
                    return attributes.toArray();
                }
                if (parameter.getDefaultPrefix().equals("prop")) {
                    return ClassUtils.getClassProperties(elementClass).keySet().toArray();
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

