/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.google.common.base.Objects;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.perforce.PerforceAuthenticationException;
import org.jetbrains.idea.perforce.perforce.PerforceServerUnavailable;

public class ConnectionInfo {
    private final Map<String, List<String>> myInfo;
    private final Map<String, List<String>> myClient;
    private final VcsException myException;

    ConnectionInfo(@NotNull Map<String, List<String>> info, @NotNull Map<String, List<String>> client) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/perforce/application/ConnectionInfo", "<init>"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/idea/perforce/application/ConnectionInfo", "<init>"));
        }
        this.myInfo = info;
        this.myClient = client;
        this.myException = null;
    }

    ConnectionInfo(VcsException exception) {
        this.myInfo = Collections.emptyMap();
        this.myClient = Collections.emptyMap();
        this.myException = exception;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionInfo)) {
            return false;
        }
        ConnectionInfo info1 = (ConnectionInfo)o;
        return this.myClient.equals(info1.myClient) && this.myInfo.equals(info1.myInfo) && Comparing.equal((Object)((Object)this.myException), (Object)((Object)info1.myException));
    }

    public int hashCode() {
        int result = this.myInfo.hashCode();
        result = 31 * result + this.myClient.hashCode();
        if (this.myException != null) {
            result = 31 * result + ((Object)((Object)this.myException)).hashCode();
        }
        return result;
    }

    public String toString() {
        if (this.myException != null) {
            return this.myException.getMessage();
        }
        return Objects.toStringHelper((Object)this).add("info", this.myInfo).add("client", this.myClient).toString();
    }

    private static void wrapAndThrow(VcsException vcsException) throws VcsException {
        if (vcsException instanceof PerforceAuthenticationException) {
            throw new PerforceAuthenticationException((PerforceAuthenticationException)((Object)vcsException));
        }
        if (vcsException instanceof PerforceServerUnavailable) {
            throw new PerforceServerUnavailable((PerforceServerUnavailable)((Object)vcsException));
        }
        throw new VcsException((Throwable)vcsException);
    }

    Map<String, List<String>> getInfo() throws VcsException {
        if (this.myException != null) {
            ConnectionInfo.wrapAndThrow(this.myException);
        }
        return Collections.unmodifiableMap(this.myInfo);
    }

    Map<String, List<String>> getClient() throws VcsException {
        if (this.myException != null) {
            ConnectionInfo.wrapAndThrow(this.myException);
        }
        return Collections.unmodifiableMap(this.myClient);
    }

    boolean hasException() {
        return this.myException != null;
    }

    boolean hasErrorsBesidesAuthentication() {
        return this.myException != null && !(this.myException instanceof PerforceAuthenticationException);
    }
}

