/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListDecorator;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;

public class PerforceLocalChangeListDecorator
implements ChangeListDecorator,
ProjectComponent {
    private final Project myProject;

    public PerforceLocalChangeListDecorator(Project project) {
        this.myProject = project;
    }

    public void decorateChangeList(LocalChangeList changeList, ColoredTreeCellRenderer cellRenderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (ChangesUtil.getDefaultChangeListName().equals(changeList.getName())) {
            return;
        }
        Collection collNumbers = PerforceNumberNameSynchronizer.getInstance(this.myProject).getAllNumbers(changeList.getName()).values();
        if (collNumbers.isEmpty()) {
            return;
        }
        String text = " - Perforce #" + StringUtil.join((Iterable)ContainerUtil.sorted((Collection)collNumbers), (String)", ");
        int shelved = PerforceManager.getInstance(this.myProject).getShelf().getShelvedChanges(changeList).size();
        if (shelved > 0) {
            text = text + "; " + shelved + " shelved change" + (shelved > 1 ? "s" : "");
        }
        cellRenderer.append(text, SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("org.jetbrains.idea.perforce.application.PerforceLocalChangeListDecorator" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceLocalChangeListDecorator", "getComponentName"));
        }
        return "org.jetbrains.idea.perforce.application.PerforceLocalChangeListDecorator";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }
}

