/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeListImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.ChangeListData;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.PerforceChange;
import org.jetbrains.idea.perforce.perforce.PerforceChangeCache;
import org.jetbrains.idea.perforce.perforce.PerforceContentRevision;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceChangeList
implements CommittedChangeList {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.perforce.PerforceChangeList");
    private Date myDate;
    private long myNumber;
    private String myDescription;
    private String myUser;
    private String myClient;
    private final Project myProject;
    private final P4Connection myConnection;
    private List<Change> myIdeaChanges;
    private final PerforceChangeCache myChangeCache;

    public PerforceChangeList(@NotNull ChangeListData data, Project project, @NotNull P4Connection connection, PerforceChangeCache changeCache) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/idea/perforce/perforce/PerforceChangeList", "<init>"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/perforce/PerforceChangeList", "<init>"));
        }
        this.myChangeCache = changeCache;
        this.myUser = data.USER;
        try {
            this.myDate = data.DATE.indexOf(58) >= 0 ? ChangeListData.DATE_FORMAT.parse(data.DATE) : ChangeListData.DATE_ONLY_FORMAT.parse(data.DATE);
        }
        catch (ParseException e) {
            LOG.error((Throwable)e);
            this.myDate = new Date();
        }
        this.myNumber = data.NUMBER;
        this.myDescription = data.DESCRIPTION;
        this.myClient = data.CLIENT;
        this.myProject = project;
        this.myConnection = connection;
    }

    public PerforceChangeList(Project project, DataInput stream, @NotNull P4Connection connection, PerforceClient perforceClient, PerforceChangeCache changeCache) throws IOException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/perforce/PerforceChangeList", "<init>"));
        }
        this.myProject = project;
        this.myChangeCache = changeCache;
        this.myConnection = connection;
        this.readFromStream(stream, perforceClient);
    }

    public String getCommitterName() {
        return this.myUser;
    }

    public Date getCommitDate() {
        return this.myDate;
    }

    public Collection<Change> getChanges() {
        if (this.myIdeaChanges == null) {
            this.myIdeaChanges = this.getChangesUnder(null);
        }
        return this.myIdeaChanges;
    }

    public List<Change> getChangesUnder(@Nullable VirtualFile root) {
        ArrayList<Change> ideaChanges = new ArrayList<Change>();
        for (PerforceChange path : this.myChangeCache.getChanges(this.myConnection, this.myNumber, root)) {
            int type = path.getType();
            PerforceContentRevision beforeRevision = type == 0 || type == 5 ? null : this.createRevision(path.getDepotPath(), path.getRevision() - 1L);
            PerforceContentRevision afterRevision = type == 1 || type == 6 ? null : this.createRevision(path.getDepotPath(), path.getRevision());
            ideaChanges.add(new Change((ContentRevision)beforeRevision, (ContentRevision)afterRevision));
        }
        return ideaChanges;
    }

    private PerforceContentRevision createRevision(String depotPath, long revision) {
        return PerforceContentRevision.create(this.myProject, this.myConnection, depotPath, revision, -1L);
    }

    @NotNull
    public String getName() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/PerforceChangeList", "getName"));
        }
        return string;
    }

    public String getComment() {
        return this.myDescription;
    }

    public long getNumber() {
        return this.myNumber;
    }

    @Nullable
    public String getBranch() {
        return null;
    }

    public AbstractVcs getVcs() {
        return PerforceVcs.getInstance(this.myProject);
    }

    public Collection<Change> getChangesWithMovedTrees() {
        return CommittedChangeListImpl.getChangesWithMovedTreesImpl((CommittedChangeList)this);
    }

    public boolean isModifiable() {
        return true;
    }

    public void setDescription(String newMessage) {
        this.myDescription = newMessage;
    }

    public String getClient() {
        return this.myClient;
    }

    public String toString() {
        return this.myDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerforceChangeList that = (PerforceChangeList)o;
        if (this.myNumber != that.myNumber) {
            return false;
        }
        if (this.myClient != null ? !this.myClient.equals(that.myClient) : that.myClient != null) {
            return false;
        }
        if (this.myDate != null ? !this.myDate.equals(that.myDate) : that.myDate != null) {
            return false;
        }
        if (this.myDescription != null ? !this.myDescription.equals(that.myDescription) : that.myDescription != null) {
            return false;
        }
        return !(this.myUser != null ? !this.myUser.equals(that.myUser) : that.myUser != null);
    }

    public int hashCode() {
        int result = this.myDate != null ? this.myDate.hashCode() : 0;
        result = 31 * result + (int)(this.myNumber ^ this.myNumber >>> 32);
        result = 31 * result + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        result = 31 * result + (this.myUser != null ? this.myUser.hashCode() : 0);
        result = 31 * result + (this.myClient != null ? this.myClient.hashCode() : 0);
        return result;
    }

    public void writeToStream(DataOutput stream) throws IOException {
        stream.writeLong(this.myNumber);
        stream.writeLong(this.myDate.getTime());
        stream.writeUTF(this.myUser);
        stream.writeUTF(this.myClient);
        IOUtil.writeUTFTruncated((DataOutput)stream, (String)this.myDescription);
        this.myConnection.getId().writeToStream(stream);
        Collection<Change> changes = this.getChanges();
        stream.writeInt(changes.size());
        for (Change change : changes) {
            PerforceContentRevision revision = (PerforceContentRevision)change.getAfterRevision();
            if (revision == null) {
                stream.writeByte(0);
                revision = (PerforceContentRevision)change.getBeforeRevision();
                assert (revision != null);
            } else {
                stream.writeByte(change.getBeforeRevision() != null ? 1 : 2);
            }
            stream.writeLong(revision.getRevision());
            stream.writeUTF(revision.getDepotPath());
        }
    }

    private void readFromStream(DataInput stream, PerforceClient perforceClient) throws IOException {
        this.myNumber = stream.readLong();
        this.myDate = new Date(stream.readLong());
        this.myUser = stream.readUTF();
        this.myClient = stream.readUTF();
        this.myDescription = stream.readUTF();
        ConnectionId.readFromStream(stream);
        int count = stream.readInt();
        this.myIdeaChanges = new ArrayList<Change>(count);
        VcsContextFactory pathService = VcsContextFactory.SERVICE.getInstance();
        for (int i = 0; i < count; ++i) {
            byte type = stream.readByte();
            long revision = stream.readLong();
            String path = stream.readUTF();
            Change change = null;
            switch (type) {
                case 0: {
                    change = new Change((ContentRevision)this.createRevisionUsingCachedClient(path, revision, perforceClient, pathService), null);
                    break;
                }
                case 1: {
                    change = new Change((ContentRevision)this.createRevisionUsingCachedClient(path, revision - 1L, perforceClient, pathService), (ContentRevision)this.createRevisionUsingCachedClient(path, revision, perforceClient, pathService));
                    break;
                }
                case 2: {
                    change = new Change(null, (ContentRevision)this.createRevisionUsingCachedClient(path, revision, perforceClient, pathService));
                    break;
                }
                default: {
                    assert (false) : "Unknown p4 change type " + type;
                    break;
                }
            }
            this.myIdeaChanges.add(change);
        }
    }

    private PerforceContentRevision createRevisionUsingCachedClient(String depotPath, long revision, PerforceClient client, VcsContextFactory pathService) {
        File file;
        try {
            file = PerforceManager.getFileByDepotName(depotPath, client);
        }
        catch (VcsException e) {
            file = null;
        }
        FilePath filePath = file != null ? pathService.createFilePathOn(file, false) : pathService.createFilePathOnNonLocal(depotPath, false);
        return PerforceContentRevision.create(this.myProject, depotPath, filePath, revision);
    }
}

