/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.javascript.flex.css.CssClassValueReference;
import com.intellij.javascript.flex.css.FlexCssUtil;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.ReferenceSupport;
import com.intellij.lang.javascript.flex.actions.newfile.CreateFlexComponentFix;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.fixes.CreateClassOrInterfaceFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexCssReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/javascript/flex/FlexCssReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(CssString.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                String funName;
                CssFunction fun = (CssFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), CssFunction.class);
                return fun != null && ("ClassReference".equals(funName = fun.getName()) || "Embed".equals(funName));
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/FlexCssReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/FlexCssReferenceContributor$1", "getReferencesByElement"));
                }
                CssFunction fun = (CssFunction)PsiTreeUtil.getParentOfType((PsiElement)element, CssFunction.class);
                if (fun != null && "Embed".equals(fun.getName())) {
                    PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)element);
                    if (prev instanceof PsiWhiteSpace) {
                        prev = PsiTreeUtil.prevLeaf((PsiElement)prev);
                    }
                    if (prev != null) {
                        prev = PsiTreeUtil.prevLeaf((PsiElement)prev);
                    }
                    if (prev instanceof PsiWhiteSpace) {
                        prev = PsiTreeUtil.prevLeaf((PsiElement)prev);
                    }
                    if (prev != null && !"source".equals(prev.getText()) && !"Embed".equals(prev.getText())) {
                        if (PsiReference.EMPTY_ARRAY == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexCssReferenceContributor$1", "getReferencesByElement"));
                        }
                        return PsiReference.EMPTY_ARRAY;
                    }
                    PsiReference[] psiReferenceArray = ReferenceSupport.getFileRefs(element, element, 1, ReferenceSupport.LookupOptions.EMBEDDED_ASSET);
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexCssReferenceContributor$1", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                final String value = StringUtil.unquoteString((String)element.getText());
                JSReferenceSet refSet = new JSReferenceSet(element, value, 1, false, true);
                if (fun != null && element instanceof CssString) {
                    assert ("ClassReference".equals(fun.getName()));
                    refSet.setLocalQuickFixProvider(new LocalQuickFixProvider(){

                        @Nullable
                        public LocalQuickFix[] getQuickFixes() {
                            CreateClassOrInterfaceFix[] fixes;
                            if (!JSUtils.isValidClassName((String)value, (boolean)true)) {
                                return LocalQuickFix.EMPTY_ARRAY;
                            }
                            for (CreateClassOrInterfaceFix fix : fixes = new CreateClassOrInterfaceFix[]{new CreateClassOrInterfaceFix(value, null, element), new CreateFlexComponentFix(value, element)}) {
                                fix.setCreatedClassFqnConsumer(newFqn -> {
                                    if (element == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/FlexCssReferenceContributor$1$1", "lambda$getQuickFixes$0"));
                                    }
                                    ElementManipulators.getManipulator((PsiElement)element).handleContentChange(element, newFqn);
                                });
                            }
                            return fixes;
                        }
                    });
                }
                PsiReference[] psiReferenceArray = refSet.getReferences();
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexCssReferenceContributor$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement().and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                PsiFile file;
                CssDeclaration cssDeclaration;
                CssTermList cssTermList;
                if ((element instanceof XmlToken || element instanceof CssString) && (cssTermList = (CssTermList)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), CssTermList.class)) != null && (cssDeclaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)cssTermList, CssDeclaration.class)) != null && cssDeclaration.getValue() == cssTermList && FlexCssUtil.isStyleNameProperty(cssDeclaration.getPropertyName()) && (file = cssDeclaration.getContainingFile()) != null) {
                    if (file.getFileType() == CssFileType.INSTANCE) {
                        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)cssDeclaration);
                        return module != null && ModuleType.get((Module)module) == FlexModuleType.getInstance();
                    }
                    return JavaScriptSupportLoader.isFlexMxmFile((PsiFile)file);
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/FlexCssReferenceContributor$4", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/FlexCssReferenceContributor$4", "getReferencesByElement"));
                }
                String styleName = CssClassValueReference.getValue(element);
                if (styleName.length() > 0) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new CssClassValueReference(element)};
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexCssReferenceContributor$4", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexCssReferenceContributor$4", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
    }
}

