/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ActionScriptAutoImportOptionsProvider;
import com.intellij.lang.javascript.flex.AddImportECMAScriptClassOrFunctionAction;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlexReferenceImporter
implements ReferenceImporter {
    public boolean autoImportReferenceAtCursor(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/flex/FlexReferenceImporter", "autoImportReferenceAtCursor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/FlexReferenceImporter", "autoImportReferenceAtCursor"));
        }
        return FlexReferenceImporter.doAutoImportReferenceAt(editor, file, editor.getCaretModel().getOffset());
    }

    public boolean autoImportReferenceAt(@NotNull Editor editor, @NotNull PsiFile file, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/flex/FlexReferenceImporter", "autoImportReferenceAt"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/FlexReferenceImporter", "autoImportReferenceAt"));
        }
        return FlexReferenceImporter.doAutoImportReferenceAt(editor, file, offset);
    }

    private static boolean doAutoImportReferenceAt(Editor editor, PsiFile file, int offset) {
        if (!ActionScriptAutoImportOptionsProvider.isAddUnambiguousImportsOnTheFly()) {
            return false;
        }
        if (!(file instanceof JSFile) || file.getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            return false;
        }
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(offset);
        int startOffset = document.getLineStartOffset(lineNumber);
        int endOffset = document.getLineEndOffset(lineNumber);
        List elements = CollectHighlightsUtil.getElementsInRange((PsiElement)file, (int)startOffset, (int)endOffset);
        for (PsiElement element : elements) {
            if (!(element instanceof JSReferenceExpression) || ((JSReferenceExpression)element).getQualifier() != null || ((JSReferenceExpression)element).multiResolve(false).length != 0) continue;
            new AddImportECMAScriptClassOrFunctionAction(editor, (PsiPolyVariantReference)element, true).execute();
            return true;
        }
        return false;
    }
}

