/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.javascript.flex.mxml.MxmlJSClass;
import com.intellij.javascript.flex.mxml.MxmlJSClassProvider;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.flex.projectStructure.FlexOrderEnumerationHandler;
import com.intellij.lang.javascript.flex.projectStructure.FlexProjectLevelCompilerOptionsHolder;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyType;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexUtils {
    @NonNls
    private static final Pattern INFO_PLIST_EXECUTABLE_PATTERN = Pattern.compile("<key>CFBundleExecutable</key>(?:(?:\\s*)(?:<!--(?:.*)-->(?:\\s*))*)<string>(.*)</string>");

    private FlexUtils() {
    }

    public static FileChooserDescriptor createFileChooserDescriptor(final String ... allowedExtensions) {
        return allowedExtensions == null ? new FileChooserDescriptor(true, false, true, true, false, false) : new FileChooserDescriptor(true, false, true, true, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || this.isAllowedExtension(file.getExtension()));
            }

            private boolean isAllowedExtension(String extension) {
                for (String allowedExtension : allowedExtensions) {
                    if (!allowedExtension.equalsIgnoreCase(extension)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static void createSampleApp(Project project, VirtualFile sourceRoot, String sampleFileName, TargetPlatform platform, boolean isFlex4) throws IOException {
        String sampleClassName = FileUtil.getNameWithoutExtension((String)sampleFileName);
        String extension = FileUtilRt.getExtension((String)sampleFileName);
        String sampleTechnology = platform == TargetPlatform.Mobile ? "AIRMobile" : (platform == TargetPlatform.Desktop ? "AIR" : "Flex");
        String suffix = "";
        if ("mxml".equalsIgnoreCase(extension)) {
            if (platform == TargetPlatform.Mobile) {
                suffix = "_ViewNavigator";
            } else if (isFlex4) {
                suffix = "_Spark";
            }
        }
        String helloWorldTemplate = "HelloWorld_" + sampleTechnology + suffix + "." + extension + ".ft";
        InputStream stream = FlexUtils.class.getResourceAsStream(helloWorldTemplate);
        assert (stream != null) : helloWorldTemplate;
        String sampleFileContent = FileUtil.loadTextAndClose((Reader)new InputStreamReader(stream)).replace("${class.name}", sampleClassName);
        VirtualFile sampleApplicationFile = FlexUtils.addFileWithContent(sampleFileName, sampleFileContent, sourceRoot);
        if (sampleApplicationFile != null) {
            Runnable runnable = () -> FileEditorManager.getInstance((Project)project).openFile(sampleApplicationFile, true);
            if (project.isInitialized()) {
                runnable.run();
            } else {
                StartupManager.getInstance((Project)project).registerPostStartupActivity(runnable);
            }
        }
    }

    public static VirtualFile addFileWithContent(@NonNls String fileName, byte[] fileContent, VirtualFile dir) throws IOException {
        VirtualFile file = dir.findChild(fileName);
        if (file == null) {
            file = dir.createChildData(FlexUtils.class, fileName);
        } else if (SystemInfo.isWindows) {
            file.rename(FlexUtils.class, fileName);
        }
        file.setBinaryContent(fileContent);
        return file;
    }

    public static VirtualFile addFileWithContent(@NonNls String fileName, @NonNls String fileContent, VirtualFile dir) throws IOException {
        VirtualFile data = dir.findChild(fileName);
        if (data == null) {
            data = dir.createChildData(FlexUtils.class, fileName);
        } else if (SystemInfo.isWindows) {
            data.rename(FlexUtils.class, fileName);
        }
        VfsUtil.saveText((VirtualFile)data, (String)fileContent);
        return data;
    }

    @Nullable
    public static Sdk getSdkForActiveBC(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/FlexUtils", "getSdkForActiveBC"));
        }
        return ModuleType.get((Module)module) instanceof FlexModuleType ? FlexBuildConfigurationManager.getInstance(module).getActiveConfiguration().getSdk() : null;
    }

    public static Map<String, List<String>> findXMLElements(@NotNull InputStream xmlInputStream, final List<String> xmlElements) {
        if (xmlInputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlInputStream", "com/intellij/lang/javascript/flex/FlexUtils", "findXMLElements"));
        }
        final HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        for (String element : xmlElements) {
            resultMap.put(element, new ArrayList());
        }
        NanoXmlUtil.parse((InputStream)xmlInputStream, (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter(){
            private String currentElement = "";
            private final StringBuilder currentElementContent = new StringBuilder();

            public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                this.currentElement = this.currentElement + "<" + name + ">";
            }

            public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
                if (xmlElements.contains(this.currentElement)) {
                    ((List)resultMap.get(this.currentElement)).add(this.currentElementContent.toString());
                    this.currentElementContent.delete(0, this.currentElementContent.length());
                }
                assert (this.currentElement.endsWith("<" + name + ">"));
                this.currentElement = this.currentElement.substring(0, this.currentElement.length() - (name.length() + 2));
            }

            public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
                if (xmlElements.contains(this.currentElement)) {
                    int read;
                    char[] chars = new char[128];
                    while ((read = reader.read(chars)) > 0) {
                        this.currentElementContent.append(chars, 0, read);
                    }
                }
            }
        });
        return resultMap;
    }

    @Nullable
    public static String findXMLElement(@NotNull InputStream xmlInputStream, final String xmlElement) {
        if (xmlInputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlInputStream", "com/intellij/lang/javascript/flex/FlexUtils", "findXMLElement"));
        }
        final Ref result = new Ref();
        NanoXmlUtil.parse((InputStream)xmlInputStream, (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter(){
            private String currentElement = "";
            private final StringBuilder xmlElementContent = new StringBuilder();

            public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                this.currentElement = this.currentElement + "<" + name + ">";
            }

            public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
                if (xmlElement.equals(this.currentElement)) {
                    result.set((Object)this.xmlElementContent.toString());
                    3.stop();
                }
                assert (this.currentElement.endsWith("<" + name + ">"));
                this.currentElement = this.currentElement.substring(0, this.currentElement.length() - (name.length() + 2));
            }

            public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
                if (xmlElement.equals(this.currentElement)) {
                    int read;
                    char[] chars = new char[128];
                    while ((read = reader.read(chars)) > 0) {
                        this.xmlElementContent.append(chars, 0, read);
                    }
                }
            }
        });
        return (String)result.get();
    }

    @Nullable
    public static String getMacExecutable(@NotNull String appFolderPath) {
        if (appFolderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appFolderPath", "com/intellij/lang/javascript/flex/FlexUtils", "getMacExecutable"));
        }
        try {
            String text = FileUtil.loadFile((File)new File(appFolderPath + "/Contents/Info.plist"));
            Matcher m = INFO_PLIST_EXECUTABLE_PATTERN.matcher(text);
            if (!m.find()) {
                return null;
            }
            return appFolderPath + "/Contents/MacOS/" + m.group(1);
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public static void removeIncorrectItemFromComboBoxIfPresent(JComboBox comboBox, Class clazz) {
        int oldSize = comboBox.getModel().getSize();
        Object firstElement = comboBox.getModel().getElementAt(0);
        if (!(oldSize <= 0 || firstElement != null && clazz.isAssignableFrom(firstElement.getClass()))) {
            Object selectedItem = comboBox.getSelectedItem();
            Object[] newObjects = new Object[oldSize - 1];
            for (int i = 0; i < newObjects.length; ++i) {
                newObjects[i] = comboBox.getModel().getElementAt(i + 1);
            }
            comboBox.setModel(new DefaultComboBoxModel<Object>(newObjects));
            comboBox.setSelectedItem(selectedItem);
        }
    }

    public static String getFlexCompilerWorkDirPath(Project project, @Nullable Sdk flexSdk) {
        VirtualFile baseDir = project.getBaseDir();
        return FlexSdkUtils.isFlex2Sdk(flexSdk) || FlexSdkUtils.isFlex3_0Sdk(flexSdk) ? FlexCommonUtils.getTempFlexConfigsDirPath() : (baseDir == null ? "" : baseDir.getPath());
    }

    public static String getPathToMainClassFile(String mainClassFqn, Module module) {
        if (StringUtil.isEmpty((String)mainClassFqn)) {
            return "";
        }
        String s = mainClassFqn.replace('.', '/');
        String[] classFileRelPaths = new String[]{s + ".mxml", s + ".as"};
        for (VirtualFile sourceRoot : ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
            for (String classFileRelPath : classFileRelPaths) {
                VirtualFile mainClassFile = VfsUtilCore.findRelativeFile((String)classFileRelPath, (VirtualFile)sourceRoot);
                if (mainClassFile == null) continue;
                return mainClassFile.getPath();
            }
        }
        return "";
    }

    public static void removeFileLater(final @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/FlexUtils", "removeFileLater"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (file.exists()) {
                                file.delete((Object)this);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
    }

    private static void processMxmlTags(XmlTag rootTag, JSResolveUtil.JSInjectedFilesVisitor injectedFilesVisitor, Processor<XmlTag> processor) {
        String namespace = FlexUtils.findMxmlNamespace(rootTag);
        XmlBackedJSClassImpl.InjectedScriptsVisitor scriptsVisitor = new XmlBackedJSClassImpl.InjectedScriptsVisitor(rootTag, (XmlBackedJSClassProvider)MxmlJSClassProvider.getInstance(), false, false, (XmlBackedJSClass.InjectedFileVisitor)injectedFilesVisitor, processor, true);
        scriptsVisitor.go();
        for (XmlTag s : rootTag.findSubTags("Metadata", namespace)) {
            processor.process((Object)s);
        }
    }

    private static String findMxmlNamespace(XmlTag rootTag) {
        String namespace = "";
        for (String candidateNs : MxmlJSClass.MXML_URIS) {
            if (rootTag.getPrefixByNamespace(candidateNs) != null) {
                namespace = candidateNs;
            }
            if (namespace.length() != 0) break;
        }
        return namespace;
    }

    public static void processMxmlTags(XmlTag rootTag, boolean isPhysical, JSResolveUtil.JSInjectedFilesVisitor injectedFilesVisitor) {
        FlexUtils.processMxmlTags(rootTag, injectedFilesVisitor, (Processor<XmlTag>)new XmlBackedJSClassImpl.InjectedScriptsVisitor.InjectingProcessor((XmlBackedJSClass.InjectedFileVisitor)injectedFilesVisitor, rootTag, isPhysical));
    }

    public static void processMetaAttributesForClass(@NotNull PsiElement jsClass, final @NotNull JSResolveUtil.MetaDataProcessor processor) {
        XmlTag rootTag;
        XmlDocument document;
        PsiFile file;
        PsiElement parent;
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/flex/FlexUtils", "processMetaAttributesForClass"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/flex/FlexUtils", "processMetaAttributesForClass"));
        }
        JSResolveUtil.processMetaAttributesForClass((PsiElement)jsClass, (JSResolveUtil.MetaDataProcessor)processor);
        if (jsClass instanceof XmlBackedJSClassImpl && (parent = jsClass.getParent()) != null && (file = parent.getContainingFile()) instanceof XmlFile && (document = ((XmlFile)file).getDocument()) != null && (rootTag = document.getRootTag()) != null) {
            JSResolveUtil.JSInjectedFilesVisitor visitor = new JSResolveUtil.JSInjectedFilesVisitor(){

                protected void process(JSFile file) {
                    if (file != null) {
                        JSResolveUtil.processMetaAttributesForClass((PsiElement)file, (JSResolveUtil.MetaDataProcessor)processor);
                    }
                }
            };
            FlexUtils.processMxmlTags(rootTag, true, visitor);
        }
    }

    public static String replacePathMacros(@NotNull String text, @NotNull Module module, String sdkRootPath) {
        int startIndex;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/flex/FlexUtils", "replacePathMacros"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/FlexUtils", "replacePathMacros"));
        }
        StringBuilder builder = new StringBuilder(text);
        int endIndex = 0;
        while ((startIndex = builder.indexOf("${", endIndex)) >= 0 && (endIndex = builder.indexOf("}", startIndex)) > startIndex) {
            String macroName = builder.substring(startIndex + 2, endIndex);
            String macroValue = "MODULE_DIR".equals(macroName) ? ModuleUtilCore.getModuleDirPath((Module)module) : ("PROJECT_DIR".equals(macroName) ? module.getProject().getBasePath() : ("USER_HOME".equals(macroName) ? StringUtil.trimEnd((String)StringUtil.trimEnd((String)SystemProperties.getUserHome(), (String)"/"), (String)"\\") : ("FLEX_SDK".equals(macroName) ? sdkRootPath : PathMacros.getInstance().getValue(macroName))));
            if (macroValue == null || StringUtil.isEmptyOrSpaces((String)macroValue)) continue;
            builder.replace(startIndex, endIndex + 1, macroValue);
            endIndex = endIndex + macroValue.length() - (macroName.length() + 3);
        }
        return builder.toString();
    }

    public static <T> boolean equalLists(List<T> list1, List<T> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        Iterator<T> iterator = list1.iterator();
        for (T element : list2) {
            if (iterator.next().equals(element)) continue;
            return false;
        }
        return true;
    }

    public static String getContentOrModuleFolderPath(Module module) {
        String[] contentRootUrls = ModuleRootManager.getInstance((Module)module).getContentRootUrls();
        return contentRootUrls.length > 0 ? VfsUtilCore.urlToPath((String)contentRootUrls[0]) : PathUtil.getParentPath((String)module.getModuleFilePath());
    }

    @Nullable
    public static VirtualFile createDirIfMissing(Project project, boolean interactive, String folderPath, String errorMessageTitle) {
        VirtualFile folder = LocalFileSystem.getInstance().findFileByPath(folderPath);
        if (folder == null) {
            try {
                folder = VfsUtil.createDirectories((String)folderPath);
            }
            catch (IOException e) {
                if (interactive) {
                    Messages.showErrorDialog((Project)project, (String)FlexBundle.message("failed.to.create.folder", FileUtil.toSystemDependentName((String)folderPath), e.getMessage()), (String)errorMessageTitle);
                }
                return null;
            }
        }
        if (folder == null) {
            if (interactive) {
                Messages.showErrorDialog((Project)project, (String)FlexBundle.message("failed.to.create.folder", folderPath, "unknown error"), (String)errorMessageTitle);
            }
            return null;
        }
        if (!folder.isDirectory()) {
            Messages.showErrorDialog((Project)project, (String)FlexBundle.message("selected.path.not.folder", FileUtil.toSystemDependentName((String)folderPath)), (String)errorMessageTitle);
            return null;
        }
        return folder;
    }

    public static boolean processCompilerOption(Module module, FlexBuildConfiguration bc, String option, Processor<Pair<String, String>> processor) {
        int index;
        String rawValue = bc.getCompilerOptions().getOption(option);
        if (rawValue == null) {
            rawValue = FlexBuildConfigurationManager.getInstance(module).getModuleLevelCompilerOptions().getOption(option);
        }
        if (rawValue == null) {
            rawValue = FlexProjectLevelCompilerOptionsHolder.getInstance(module.getProject()).getProjectLevelCompilerOptions().getOption(option);
        }
        if (rawValue == null) {
            return true;
        }
        int pos = 0;
        while ((index = rawValue.indexOf("\n", pos)) != -1) {
            String token = rawValue.substring(pos, index);
            int tabIndex = token.indexOf("\t");
            if (tabIndex > 0 && !processor.process((Object)Pair.create((Object)token.substring(0, tabIndex), (Object)token.substring(tabIndex + 1)))) {
                return false;
            }
            pos = index + 1;
        }
        int tabIndex = rawValue.indexOf("\t", pos);
        return tabIndex <= pos || processor.process((Object)Pair.create((Object)rawValue.substring(pos, tabIndex), (Object)rawValue.substring(tabIndex + 1)));
    }

    public static LinkageType convertLinkageType(DependencyScope scope, boolean isExported) {
        if (scope == DependencyScope.PROVIDED) {
            return LinkageType.External;
        }
        if (scope == DependencyScope.TEST) {
            return LinkageType.Test;
        }
        if (isExported) {
            return LinkageType.Include;
        }
        return DependencyType.DEFAULT_LINKAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleWithDependenciesScope getModuleWithDependenciesAndLibrariesScope(@NotNull Module module, @NotNull FlexBuildConfiguration bc, boolean includeTests) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/FlexUtils", "getModuleWithDependenciesAndLibrariesScope"));
        }
        if (bc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/lang/javascript/flex/FlexUtils", "getModuleWithDependenciesAndLibrariesScope"));
        }
        module.putUserData(FlexOrderEnumerationHandler.FORCE_BC, (Object)bc);
        try {
            ModuleWithDependenciesScope moduleWithDependenciesScope = new ModuleWithDependenciesScope(module, 7 | (includeTests ? 8 : 0));
            return moduleWithDependenciesScope;
        }
        finally {
            module.putUserData(FlexOrderEnumerationHandler.FORCE_BC, null);
        }
    }

    public static String getOwnIpAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                Enumeration<InetAddress> inetAddresses = networkInterfaces.nextElement().getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "unknown";
    }

    public static boolean isMxmlNs(String ns) {
        return ArrayUtil.contains((String)ns, (String[])MxmlJSClass.MXML_URIS);
    }
}

