/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.airpackage;

import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.actions.ExternalTask;
import com.intellij.lang.javascript.flex.actions.airpackage.AirPackageDialog;
import com.intellij.lang.javascript.flex.actions.airpackage.AirPackageProjectParameters;
import com.intellij.lang.javascript.flex.actions.airpackage.AirPackageUtil;
import com.intellij.lang.javascript.flex.actions.airpackage.KeystorePasswordDialog;
import com.intellij.lang.javascript.flex.actions.airpackage.PasswordStore;
import com.intellij.lang.javascript.flex.build.FlexResourceBuildTargetScopeProvider;
import com.intellij.lang.javascript.flex.projectStructure.model.AirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AirSigningOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.model.IosPackagingOptions;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AirPackageAction
extends DumbAwareAction {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"AIR Packaging");

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        boolean flexModulePresent = false;
        boolean airAppPresent = false;
        if (project != null) {
            FlexModuleType flexModuleType = FlexModuleType.getInstance();
            block0: for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                if (ModuleType.get((Module)module) != flexModuleType) continue;
                flexModulePresent = true;
                for (FlexBuildConfiguration bc : FlexBuildConfigurationManager.getInstance(module).getBuildConfigurations()) {
                    BuildConfigurationNature nature = bc.getNature();
                    if (!nature.isApp() || nature.isWebPlatform()) continue;
                    airAppPresent = true;
                    break block0;
                }
            }
        }
        e.getPresentation().setVisible(flexModulePresent);
        e.getPresentation().setEnabled(airAppPresent && !CompilerManager.getInstance((Project)project).isCompilationActive() && !AirPackageProjectParameters.getInstance(project).isPackagingInProgress());
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = e.getProject();
        if (project == null) {
            return;
        }
        final AirPackageDialog dialog = new AirPackageDialog(project);
        if (!dialog.showAndGet()) {
            return;
        }
        final Collection<Pair<Module, FlexBuildConfiguration>> modulesAndBCs = dialog.getSelectedBCs();
        THashSet modules = new THashSet();
        for (Pair<Module, FlexBuildConfiguration> bc : modulesAndBCs) {
            modules.add(bc.first);
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        CompileScope compileScope = compilerManager.createModulesCompileScope(modules.toArray(new Module[modules.size()]), false);
        FlexResourceBuildTargetScopeProvider.setBCsToCompileForPackaging(compileScope, modulesAndBCs);
        compilerManager.make(compileScope, new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (!aborted && errors == 0) {
                    AirPackageAction.createPackages(project, modulesAndBCs, dialog.getPasswords());
                }
            }
        });
    }

    private static void createPackages(Project project, Collection<Pair<Module, FlexBuildConfiguration>> modulesAndBCs, PasswordStore passwords) {
        ArrayList<Pair<ExternalTask, String>> tasksAndPackagePaths = new ArrayList<Pair<ExternalTask, String>>();
        AirPackageProjectParameters params = AirPackageProjectParameters.getInstance(project);
        for (Pair<Module, FlexBuildConfiguration> moduleAndBC : modulesAndBCs) {
            AirPackagingOptions packagingOptions;
            String packagePath;
            ExternalTask task;
            FlexBuildConfiguration bc = (FlexBuildConfiguration)moduleAndBC.second;
            String outputFolder = PathUtil.getParentPath((String)bc.getActualOutputFilePath());
            if (bc.getTargetPlatform() == TargetPlatform.Desktop) {
                AirPackageProjectParameters.DesktopPackageType packageType = params.desktopPackageType;
                task = AirPackageUtil.createAirDesktopTask((Module)moduleAndBC.first, bc, packageType, passwords);
                packagePath = outputFolder + "/" + bc.getAirDesktopPackagingOptions().getPackageFileName() + packageType.getFileExtension();
                tasksAndPackagePaths.add((Pair<ExternalTask, String>)Pair.create((Object)task, (Object)packagePath));
                continue;
            }
            if (bc.getAndroidPackagingOptions().isEnabled()) {
                packagingOptions = bc.getAndroidPackagingOptions();
                task = AirPackageUtil.createAndroidPackageTask((Module)moduleAndBC.first, bc, params.androidPackageType, params.apkCaptiveRuntime, params.apkDebugListenPort, passwords);
                packagePath = outputFolder + "/" + packagingOptions.getPackageFileName() + ".apk";
                tasksAndPackagePaths.add((Pair<ExternalTask, String>)Pair.create((Object)task, (Object)packagePath));
            }
            if (!bc.getIosPackagingOptions().isEnabled()) continue;
            packagingOptions = bc.getIosPackagingOptions();
            task = AirPackageUtil.createIOSPackageTask((Module)moduleAndBC.first, bc, params.iosPackageType, params.iosFastPackaging, bc.getIosPackagingOptions().getSigningOptions().getIOSSdkPath(), 0, passwords);
            packagePath = outputFolder + "/" + packagingOptions.getPackageFileName() + ".ipa";
            tasksAndPackagePaths.add((Pair<ExternalTask, String>)Pair.create((Object)task, (Object)packagePath));
        }
        AirPackageAction.createPackages(project, tasksAndPackagePaths);
    }

    private static void createPackages(Project project, Collection<Pair<ExternalTask, String>> tasksAndPackagePaths) {
        Iterator<Pair<ExternalTask, String>> iterator = tasksAndPackagePaths.iterator();
        Pair<ExternalTask, String> taskAndPackagePath = iterator.next();
        ExternalTask task = (ExternalTask)taskAndPackagePath.first;
        String packagePath = (String)taskAndPackagePath.second;
        Consumer<List<String>> onSuccessRunnable = AirPackageAction.createSuccessConsumer(project, iterator, packagePath, (Map<String, List<String>>)new THashMap());
        ExternalTask.runInBackground(task, FlexBundle.message("packaging.air.application", PathUtil.getFileName((String)packagePath)), onSuccessRunnable, AirPackageAction.createFailureConsumer(project, packagePath, task));
    }

    private static Consumer<List<String>> createSuccessConsumer(Project project, Iterator<Pair<ExternalTask, String>> iterator, String createdPackagePath, Map<String, List<String>> packagePathsToWarnings) {
        return messages -> {
            packagePathsToWarnings.put(createdPackagePath, (List<String>)messages);
            if (iterator.hasNext()) {
                Pair taskAndPackagePath = (Pair)iterator.next();
                ExternalTask task = (ExternalTask)taskAndPackagePath.first;
                String packagePath = (String)taskAndPackagePath.second;
                Consumer<List<String>> onSuccessRunnable = AirPackageAction.createSuccessConsumer(project, iterator, packagePath, packagePathsToWarnings);
                ExternalTask.runInBackground(task, FlexBundle.message("packaging.air.application", PathUtil.getFileName((String)packagePath)), onSuccessRunnable, AirPackageAction.createFailureConsumer(project, packagePath, task));
            } else {
                StringBuilder hrefs = new StringBuilder();
                for (Map.Entry entry : packagePathsToWarnings.entrySet()) {
                    String packagePath = (String)entry.getKey();
                    List warnings = (List)entry.getValue();
                    if (hrefs.length() > 0) {
                        hrefs.append("<br>");
                    }
                    hrefs.append("<a href='").append(packagePath).append("'>").append(PathUtil.getFileName((String)packagePath)).append("</a>");
                    if (warnings.isEmpty()) continue;
                    hrefs.append("<br>");
                    for (String warning : warnings) {
                        hrefs.append(warning).append("<br>");
                    }
                }
                String message = FlexBundle.message("air.application.created", packagePathsToWarnings.size(), hrefs);
                NotificationListener listener = new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                        if (notification == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/lang/javascript/flex/actions/airpackage/AirPackageAction$2", "hyperlinkUpdate"));
                        }
                        if (event == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/flex/actions/airpackage/AirPackageAction$2", "hyperlinkUpdate"));
                        }
                        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            notification.expire();
                            String packagePath = event.getDescription();
                            ShowFilePathAction.openFile((File)new File(packagePath));
                        }
                    }
                };
                NOTIFICATION_GROUP.createNotification("", message, NotificationType.INFORMATION, listener).notify(project);
            }
        };
    }

    private static Consumer<List<String>> createFailureConsumer(final Project project, String packagePath, final ExternalTask task) {
        return messages -> {
            String reason = StringUtil.join((Collection)messages, (String)"<br>");
            if (reason.length() > 1000) {
                reason = reason.substring(0, 1000) + "...";
            }
            NOTIFICATION_GROUP.createNotification("", FlexBundle.message("failed.to.create.air.package", PathUtil.getFileName((String)packagePath), reason), NotificationType.ERROR, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/lang/javascript/flex/actions/airpackage/AirPackageAction$3", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/flex/actions/airpackage/AirPackageAction$3", "hyperlinkUpdate"));
                    }
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        notification.expire();
                        Messages.showIdeaMessageDialog((Project)project, (String)task.getCommandLine(), (String)"ADT Command Line", (String[])new String[]{Messages.OK_BUTTON}, (int)0, null, null);
                    }
                }
            }).notify(project);
        };
    }

    @Nullable
    public static PasswordStore getPasswords(Project project, Collection<? extends AirPackagingOptions> allPackagingOptions) {
        ArrayList<AirSigningOptions> signingOptionsWithUnknownPasswords = new ArrayList<AirSigningOptions>();
        for (AirPackagingOptions airPackagingOptions : allPackagingOptions) {
            AirSigningOptions signingOptions = airPackagingOptions.getSigningOptions();
            boolean tempCertificate = !(airPackagingOptions instanceof IosPackagingOptions) && signingOptions.isUseTempCertificate();
            if (tempCertificate || PasswordStore.isPasswordKnown(project, signingOptions)) continue;
            signingOptionsWithUnknownPasswords.add(signingOptions);
        }
        if (!signingOptionsWithUnknownPasswords.isEmpty()) {
            KeystorePasswordDialog dialog = new KeystorePasswordDialog(project, signingOptionsWithUnknownPasswords);
            return dialog.showAndGet() ? dialog.getPasswords() : null;
        }
        return PasswordStore.getInstance(project);
    }
}

