/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.airpackage;

import com.intellij.lang.javascript.flex.actions.airpackage.AirPackageProjectParameters;
import com.intellij.lang.javascript.flex.projectStructure.model.AirSigningOptions;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.annotations.Transient;
import gnu.trove.THashMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class PasswordStore {
    @Transient
    private boolean rememberPasswords = true;
    @Transient
    private Map<String, String> myStoredPasswords = new THashMap();

    public static PasswordStore getInstance(Project project) {
        return AirPackageProjectParameters.getPasswordStore(project);
    }

    public boolean isRememberPasswords() {
        return this.rememberPasswords;
    }

    public void setRememberPasswords(boolean rememberPasswords) {
        this.rememberPasswords = rememberPasswords;
    }

    @Nullable
    public String getKeystorePassword(String keystorePath) {
        return this.myStoredPasswords.get(keystorePath);
    }

    @Nullable
    public String getKeyPassword(String keystorePath, String keyAlias) {
        return this.myStoredPasswords.get(keystorePath + "*" + keyAlias);
    }

    public void clearPasswords() {
        this.myStoredPasswords.clear();
    }

    public void storeKeystorePassword(String keystorePath, String keystorePassword) {
        this.myStoredPasswords.put(keystorePath, keystorePassword);
    }

    public void storeKeyPassword(String keystorePath, String keyAlias, String keyPassword) {
        this.myStoredPasswords.put(keystorePath + "*" + keyAlias, keyPassword);
    }

    public static boolean isPasswordKnown(Project project, AirSigningOptions signingOptions) {
        String keyPassword;
        PasswordStore passwordStore = PasswordStore.getInstance(project);
        String keystorePassword = passwordStore.getKeystorePassword(signingOptions.getKeystorePath());
        String string = keyPassword = signingOptions.getKeyAlias().isEmpty() ? "" : passwordStore.getKeyPassword(signingOptions.getKeystorePath(), signingOptions.getKeyAlias());
        if (keystorePassword == null || keyPassword == null) {
            return false;
        }
        try {
            PasswordStore.checkPassword(signingOptions, keystorePassword, keyPassword);
        }
        catch (SigningOptionsException e) {
            return false;
        }
        return true;
    }

    public static void checkPassword(AirSigningOptions signingOptions, String keystorePassword, String keyPassword) throws SigningOptionsException {
        KeyStore keyStore;
        try {
            keyStore = signingOptions.getProvider().isEmpty() ? KeyStore.getInstance(signingOptions.getKeystoreType()) : KeyStore.getInstance(signingOptions.getKeystoreType(), signingOptions.getProvider());
        }
        catch (KeyStoreException ex) {
            throw new SigningOptionsException("Keystore type is not available: " + signingOptions.getKeystoreType());
        }
        catch (NoSuchProviderException ex) {
            throw new SigningOptionsException("Provider is not available: " + signingOptions.getProvider());
        }
        try {
            try {
                keyStore.load(new FileInputStream(signingOptions.getKeystorePath()), keystorePassword.toCharArray());
            }
            catch (IOException ex) {
                throw new SigningOptionsException("Incorrect keystore password", true, false);
            }
            catch (CertificateException ex) {
                throw new SigningOptionsException("Failed to load a certificate");
            }
            String keyAlias = signingOptions.getKeyAlias();
            if (keyAlias.isEmpty()) {
                if (!keyStore.aliases().hasMoreElements()) {
                    throw new SigningOptionsException("Failed to obtain the key.");
                }
                keyAlias = keyStore.aliases().nextElement();
            }
            try {
                if (keyPassword.isEmpty()) {
                    keyPassword = keystorePassword;
                }
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, keyPassword.toCharArray());
            }
            catch (UnrecoverableKeyException ex) {
                throw new SigningOptionsException("Incorrect key password", false, true);
            }
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException("Failed to load keystore");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SigningOptionsException("required crypto algorithm not available");
        }
    }

    public static class SigningOptionsException
    extends Exception {
        public final boolean wrongKeystorePassword;
        public final boolean wrongKeyPassword;

        public SigningOptionsException(String message) {
            this(message, false, false);
        }

        public SigningOptionsException(String message, boolean wrongKeystorePassword, boolean wrongKeyPassword) {
            super(message);
            this.wrongKeystorePassword = wrongKeystorePassword;
            this.wrongKeyPassword = wrongKeyPassword;
        }
    }
}

