/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.flex.model.bc.OutputType;
import com.intellij.lang.javascript.flex.build.BuiltInFlexCompilerHandler;
import com.intellij.lang.javascript.flex.build.FlexCompilationManager;
import com.intellij.lang.javascript.flex.build.FlexCompilationTask;
import com.intellij.lang.javascript.flex.build.FlexCompilationUtils;
import com.intellij.lang.javascript.flex.build.FlexCompilerHandler;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BuiltInCompilationTask
extends FlexCompilationTask {
    private final BuiltInFlexCompilerHandler myBuiltInFlexCompilerHandler;
    private BuiltInFlexCompilerHandler.Listener myListener;

    public BuiltInCompilationTask(@NotNull Module module, @NotNull FlexBuildConfiguration bc, @NotNull Collection<FlexBuildConfiguration> dependencies) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/build/BuiltInCompilationTask", "<init>"));
        }
        if (bc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/lang/javascript/flex/build/BuiltInCompilationTask", "<init>"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/intellij/lang/javascript/flex/build/BuiltInCompilationTask", "<init>"));
        }
        super(module, bc, dependencies);
        this.myBuiltInFlexCompilerHandler = FlexCompilerHandler.getInstance(module.getProject()).getBuiltInFlexCompilerHandler();
    }

    @Override
    protected void doStart(FlexCompilationManager compilationManager) {
        String plainCommand = StringUtil.join(this.buildCommand(), s -> s.indexOf(32) >= 0 && (!s.startsWith("\"") || !s.endsWith("\"")) ? '\"' + s + '\"' : s, (String)" ");
        compilationManager.addMessage(this, CompilerMessageCategory.INFORMATION, plainCommand, null, -1, -1);
        this.myListener = this.createListener(compilationManager);
        this.myBuiltInFlexCompilerHandler.sendCompilationCommand(plainCommand, this.myListener);
    }

    private List<String> buildCommand() {
        boolean app = this.myBC.getOutputType() != OutputType.Library;
        List<String> compilerCommand = Collections.singletonList(app ? "mxmlc" : "compc");
        return FlexCompilationUtils.buildCommand(compilerCommand, this.getConfigFiles(), this.myModule, this.myBC);
    }

    private BuiltInFlexCompilerHandler.Listener createListener(final FlexCompilationManager compilationManager) {
        return new BuiltInFlexCompilerHandler.Listener(){

            @Override
            public void textAvailable(String text) {
                boolean ok = FlexCompilationUtils.handleCompilerOutput(compilationManager, BuiltInCompilationTask.this, text);
                if (!ok) {
                    BuiltInCompilationTask.this.myCompilationFailed = true;
                }
            }

            @Override
            public void compilationFinished() {
                BuiltInCompilationTask.this.myFinished = true;
            }
        };
    }

    @Override
    protected void doCancel() {
        if (this.myListener != null) {
            this.myBuiltInFlexCompilerHandler.removeListener(this.myListener);
        }
    }
}

