/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.library;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class FlexDocsRootDetector
extends RootDetector {
    public FlexDocsRootDetector() {
        super(JavadocOrderRootType.getInstance(), false, FlexBundle.message("docs.root.detector.name", new Object[0]));
    }

    @NotNull
    public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
        if (rootCandidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCandidate", "com/intellij/lang/javascript/flex/library/FlexDocsRootDetector", "detectRoots"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/lang/javascript/flex/library/FlexDocsRootDetector", "detectRoots"));
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        FlexDocsRootDetector.collectRoots(rootCandidate, result, progressIndicator);
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/library/FlexDocsRootDetector", "detectRoots"));
        }
        return arrayList;
    }

    private static void collectRoots(VirtualFile file, final List<VirtualFile> result, final ProgressIndicator progressIndicator) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/library/FlexDocsRootDetector$1", "visitFile"));
                }
                progressIndicator.checkCanceled();
                if (!file.isDirectory()) {
                    return false;
                }
                progressIndicator.setText2(file.getPresentableUrl());
                if (file.findChild("all-classes.html") != null) {
                    result.add(file);
                    return false;
                }
                return true;
            }
        });
    }
}

