/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.model.impl;

import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.projectStructure.model.AirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AirSigningOptions;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AirPackagingOptionsBase {
    private boolean myEnabled = false;
    private boolean myUseGeneratedDescriptor = true;
    @NotNull
    private String myCustomDescriptorPath = "";
    @NotNull
    private String myPackageFileName = "";
    @NotNull
    private final List<AirPackagingOptions.FilePathAndPathInPackage> myFilesToPackage = new ArrayList<AirPackagingOptions.FilePathAndPathInPackage>();
    @NotNull
    private AirSigningOptions mySigningOptions = new AirSigningOptions();

    AirPackagingOptionsBase() {
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public boolean isUseGeneratedDescriptor() {
        return this.myUseGeneratedDescriptor;
    }

    public void setUseGeneratedDescriptor(boolean useGeneratedDescriptor) {
        this.myUseGeneratedDescriptor = useGeneratedDescriptor;
    }

    @NotNull
    public String getCustomDescriptorPath() {
        String string = this.myCustomDescriptorPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/AirPackagingOptionsBase", "getCustomDescriptorPath"));
        }
        return string;
    }

    public void setCustomDescriptorPath(@NotNull String customDescriptorPath) {
        if (customDescriptorPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customDescriptorPath", "com/intellij/lang/javascript/flex/projectStructure/model/impl/AirPackagingOptionsBase", "setCustomDescriptorPath"));
        }
        this.myCustomDescriptorPath = customDescriptorPath;
    }

    @NotNull
    public String getPackageFileName() {
        String string = this.myPackageFileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/AirPackagingOptionsBase", "getPackageFileName"));
        }
        return string;
    }

    public void setPackageFileName(@NotNull String packageFileName) {
        if (packageFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFileName", "com/intellij/lang/javascript/flex/projectStructure/model/impl/AirPackagingOptionsBase", "setPackageFileName"));
        }
        this.myPackageFileName = packageFileName;
    }

    @NotNull
    public List<AirPackagingOptions.FilePathAndPathInPackage> getFilesToPackage() {
        List<AirPackagingOptions.FilePathAndPathInPackage> list = AirPackagingOptionsBase.cloneList(this.myFilesToPackage);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/AirPackagingOptionsBase", "getFilesToPackage"));
        }
        return list;
    }

    public void setFilesToPackage(@NotNull List<AirPackagingOptions.FilePathAndPathInPackage> filesToPackage) {
        if (filesToPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToPackage", "com/intellij/lang/javascript/flex/projectStructure/model/impl/AirPackagingOptionsBase", "setFilesToPackage"));
        }
        this.myFilesToPackage.clear();
        for (AirPackagingOptions.FilePathAndPathInPackage filePathAndPathInPackage : filesToPackage) {
            this.myFilesToPackage.add(filePathAndPathInPackage.clone());
        }
    }

    @NotNull
    public AirSigningOptions getSigningOptions() {
        AirSigningOptions airSigningOptions = this.mySigningOptions;
        if (airSigningOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/AirPackagingOptionsBase", "getSigningOptions"));
        }
        return airSigningOptions;
    }

    public void setSigningOptions(@NotNull AirSigningOptions signingOptions) {
        if (signingOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signingOptions", "com/intellij/lang/javascript/flex/projectStructure/model/impl/AirPackagingOptionsBase", "setSigningOptions"));
        }
        this.mySigningOptions = signingOptions;
    }

    void applyTo(AirPackagingOptionsBase copy) {
        copy.myEnabled = this.myEnabled;
        copy.myUseGeneratedDescriptor = this.myUseGeneratedDescriptor;
        copy.myCustomDescriptorPath = this.myCustomDescriptorPath;
        copy.myPackageFileName = this.myPackageFileName;
        copy.setFilesToPackage(this.myFilesToPackage);
        copy.mySigningOptions = this.mySigningOptions.getCopy();
    }

    public boolean isEqual(AirPackagingOptionsBase copy) {
        if (copy.myEnabled != this.myEnabled) {
            return false;
        }
        if (copy.myUseGeneratedDescriptor != this.myUseGeneratedDescriptor) {
            return false;
        }
        if (!copy.myCustomDescriptorPath.equals(this.myCustomDescriptorPath)) {
            return false;
        }
        if (!copy.myPackageFileName.equals(this.myPackageFileName)) {
            return false;
        }
        if (!FlexUtils.equalLists(copy.myFilesToPackage, this.myFilesToPackage)) {
            return false;
        }
        return copy.mySigningOptions.equals(this.mySigningOptions);
    }

    private static List<AirPackagingOptions.FilePathAndPathInPackage> cloneList(List<AirPackagingOptions.FilePathAndPathInPackage> filesToPackage) {
        ArrayList<AirPackagingOptions.FilePathAndPathInPackage> clonedList = new ArrayList<AirPackagingOptions.FilePathAndPathInPackage>();
        for (AirPackagingOptions.FilePathAndPathInPackage filePathAndPathInPackage : filesToPackage) {
            clonedList.add(filePathAndPathInPackage.clone());
        }
        return clonedList;
    }
}

