/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections.htmlAddLabelToForm;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNewLabelAction
implements LocalQuickFix,
HighPriorityAction {
    private final String myName;

    public CreateNewLabelAction(String name) {
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = XmlBundle.message((String)"html.inspections.create.new.label", (Object[])new Object[]{this.myName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/htmlAddLabelToForm/CreateNewLabelAction", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/htmlAddLabelToForm/CreateNewLabelAction", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/htmlAddLabelToForm/CreateNewLabelAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/htmlInspections/htmlAddLabelToForm/CreateNewLabelAction", "applyFix"));
        }
        XmlTag myTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlTag.class);
        if (myTag == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(myTag.getContainingFile())) {
            return;
        }
        String id = CreateNewLabelAction.getId(myTag);
        if (id != null) {
            String text = "<label for=\"" + id + "\"></label>";
            XmlTag tag = CreateNewLabelAction.createElementFromText(project, myTag, text);
            PsiElement added = myTag.getParent().addBefore((PsiElement)tag, (PsiElement)myTag);
            XmlToken token = XmlUtil.getTokenOfType((PsiElement)added, (IElementType)XmlTokenType.XML_END_TAG_START);
            if (token != null) {
                PsiNavigateUtil.navigate((PsiElement)token);
            }
        } else {
            String text = "<label>\n" + myTag.getText() + "\n</label>";
            XmlTag tag = CreateNewLabelAction.createElementFromText(project, myTag, text);
            myTag.getParent().addBefore((PsiElement)tag, (PsiElement)myTag);
            myTag.delete();
        }
    }

    @Nullable
    static String getId(XmlTag tag) {
        XmlAttribute idAttribute = null;
        for (XmlAttribute attribute : tag.getAttributes()) {
            if (!attribute.getName().equalsIgnoreCase("id")) continue;
            idAttribute = attribute;
        }
        return idAttribute != null ? idAttribute.getValue() : null;
    }

    @NotNull
    static XmlTag createElementFromText(Project project, XmlTag myTag, String text) {
        XmlTag xmlTag = myTag instanceof HtmlTag ? XmlElementFactory.getInstance((Project)project).createHTMLTagFromText(text) : XmlElementFactory.getInstance((Project)project).createXHTMLTagFromText(text);
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/htmlAddLabelToForm/CreateNewLabelAction", "createElementFromText"));
        }
        return xmlTag;
    }
}

