/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlReferenceProvider;
import org.intellij.images.index.ImageInfoIndex;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckImageSizeInspection
extends XmlSuppressableInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.util.CheckImageSizeInspection");

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/xml/util/CheckImageSizeInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                XmlAttributeValue value;
                XmlTag parent = attribute.getParent();
                if (!(parent instanceof HtmlTag) || XmlHighlightVisitor.isInjectedWithoutValidation((PsiElement)parent)) {
                    return;
                }
                String name = attribute.getName();
                if (("height".equalsIgnoreCase(name) || "width".equalsIgnoreCase(name)) && (value = attribute.getValueElement()) != null && value.getTextLength() > 0) {
                    HtmlReferenceProvider.SizeReference sizeReference;
                    PsiElement element;
                    PsiReference[] refs = value.getReferences();
                    boolean isHeight = "height".equalsIgnoreCase(name);
                    if (refs.length == 1 && refs[0] instanceof HtmlReferenceProvider.SizeReference && refs[0].getRangeInElement().getLength() >= 2 && (element = (sizeReference = (HtmlReferenceProvider.SizeReference)refs[0]).resolve()) == null) {
                        ImageInfoIndex.ImageInfo imageInfo = sizeReference.getImageInfo();
                        if (imageInfo == null || imageInfo.height == 0 || imageInfo.width == 0) {
                            return;
                        }
                        String adequateValue = String.valueOf(isHeight ? imageInfo.height : imageInfo.width);
                        String message = XmlBundle.message((String)(isHeight ? "html.inspections.check.image.height.fix.message" : "html.inspections.check.image.width.fix.message"), (Object[])new Object[]{adequateValue});
                        MyFix fix = new MyFix(message, adequateValue);
                        holder.registerProblem((PsiElement)value, XmlBundle.message((String)(isHeight ? "html.inspections.check.image.height.message" : "html.inspections.check.image.width.message"), (Object[])new Object[]{adequateValue}), new LocalQuickFix[]{fix});
                    }
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckImageSizeInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = XmlInspectionGroupNames.HTML_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckImageSizeInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.check.image.size", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckImageSizeInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("CheckImageSize" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckImageSizeInspection", "getShortName"));
        }
        return "CheckImageSize";
    }

    private static class MyFix
    implements LocalQuickFix {
        private final String myMessage;
        private final String myAdequateValue;

        private MyFix(String message, String adequateValue) {
            this.myMessage = message;
            this.myAdequateValue = adequateValue;
        }

        @NotNull
        public String getName() {
            String string = this.myMessage;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckImageSizeInspection$MyFix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/util/CheckImageSizeInspection$MyFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xml/util/CheckImageSizeInspection$MyFix", "applyFix"));
            }
            XmlAttributeValue value = (XmlAttributeValue)descriptor.getPsiElement();
            if (value == null) {
                return;
            }
            try {
                ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)value);
                assert (manipulator != null);
                PsiReference[] refs = value.getReferences();
                if (refs.length != 1) {
                    return;
                }
                manipulator.handleContentChange((PsiElement)value, refs[0].getRangeInElement(), this.myAdequateValue);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/CheckImageSizeInspection$MyFix", "getFamilyName"));
            }
            return string;
        }
    }
}

