/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PathKt;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.BaseRepositoryManagerKt;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.RepositoryManager;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H$J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0015H$J\b\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J>\u0010\u001b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00150\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00150\u001fH\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\"\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006#"}, d2={"Lorg/jetbrains/settingsRepository/BaseRepositoryManager;", "Lorg/jetbrains/settingsRepository/RepositoryManager;", "dir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getDir", "()Ljava/nio/file/Path;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "addToIndex", "", "file", "path", "", "content", "", "size", "", "delete", "", "deleteFromIndex", "isFile", "deleteRepository", "has", "isPathIgnored", "processChildren", "filter", "Lkotlin/Function1;", "processor", "Lkotlin/Function2;", "Ljava/io/InputStream;", "read", "write", "settings-repository"})
public abstract class BaseRepositoryManager
implements RepositoryManager {
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final Path dir;

    @NotNull
    protected final ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void processChildren(@NotNull String path, @NotNull Function1<? super String, Boolean> filter, @NotNull Function2<? super String, ? super InputStream, Boolean> processor) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        Path path2 = this.dir.resolve(path);
        try {
            void $receiver$iv;
            Closeable closeable = Files.newDirectoryStream((Path)$receiver$iv);
            boolean bl = false;
            try {
                DirectoryStream it = (DirectoryStream)closeable;
                for (Path file : it) {
                    if (PathKt.isDirectory((Path)file) || PathKt.isHidden((Path)file)) continue;
                    if (PathKt.size((Path)file) == 0L) {
                        if (!PathKt.exists((Path)file)) continue;
                        try {
                            IcsManagerKt.getLOG().warn("File " + path + " is empty (length 0), will be removed");
                            Path path3 = file;
                            Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"file");
                            this.delete(path3, path);
                        }
                        catch (Exception e) {
                            IcsManagerKt.getLOG().error((Throwable)e);
                        }
                        continue;
                    }
                    String string = ((Object)file.getFileName()).toString();
                    InputStream inputStream = PathKt.inputStream((Path)file);
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"file.inputStream()");
                    if (((Boolean)processor.invoke((Object)string, (Object)inputStream)).booleanValue()) continue;
                    break;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception exception) {
                bl = true;
                try {
                    Closeable closeable2 = closeable;
                    if (closeable2 != null) {
                        closeable2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    Closeable closeable3 = closeable;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
            }
        }
        catch (NoSuchFileException ignored$iv) {
        }
    }

    @Override
    public void deleteRepository() {
        PathKt.deleteRecursively((Path)this.dir);
    }

    protected boolean isPathIgnored(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public InputStream read(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (this.isPathIgnored(path)) {
            Logger $receiver$iv = IcsManagerKt.getLOG();
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                String string = path + " is ignored";
                logger.debug(string);
            }
            return null;
        }
        Ref.ObjectRef $receiver$iv = new Ref.ObjectRef();
        $receiver$iv.element = null;
        ReentrantReadWriteLock $i$a$1$debug = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = $i$a$1$debug.readLock();
        readLock.lock();
        try {
            Path file = this.dir.resolve(path);
            long l = PathKt.sizeOrNull((Path)file);
            if (l == -1L) {
                InputStream inputStream = null;
                return inputStream;
            }
            if (l != 0L) {
                InputStream inputStream = PathKt.inputStream((Path)file);
                return inputStream;
            }
            fileToDelete.element = file;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        try {
            int n;
            $i$a$1$debug = this.lock;
            readLock = $i$a$1$debug.readLock();
            int n2 = $i$a$1$debug.getWriteHoldCount() == 0 ? $i$a$1$debug.getReadHoldCount() : 0;
            int n3 = 0;
            int n4 = n2 - 1;
            if (n3 <= n4) {
                do {
                    n = ++n3;
                    readLock.unlock();
                } while (n3 != n4);
            }
            ReentrantReadWriteLock.WriteLock writeLock = $i$a$1$debug.writeLock();
            writeLock.lock();
            try {
                void fileToDelete;
                Path path2 = (Path)fileToDelete.element;
                if (path2 == null) {
                    Intrinsics.throwNpe();
                }
                if (PathKt.sizeOrNull((Path)path2) == 0L) {
                    IcsManagerKt.getLOG().warn("File " + path + " is empty (length 0), will be removed");
                    Path path3 = (Path)fileToDelete.element;
                    if (path3 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.delete(path3, path);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n = 0;
                int n5 = n2 - 1;
                if (n <= n5) {
                    do {
                        int n6 = ++n;
                        readLock.lock();
                    } while (n != n5);
                }
                writeLock.unlock();
            }
        }
        catch (Exception e) {
            IcsManagerKt.getLOG().error((Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean write(@NotNull String path, @NotNull byte[] content, int size) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        if (this.isPathIgnored(path)) {
            void $receiver$iv;
            Logger logger = IcsManagerKt.getLOG();
            if ($receiver$iv.isDebugEnabled()) {
                void var12_7 = $receiver$iv;
                String string = path + " is ignored";
                var12_7.debug(string);
            }
            return false;
        }
        Object $receiver$iv = IcsManagerKt.getLOG();
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Write " + path;
            logger.debug(string);
        }
        try {
            int n;
            $receiver$iv = this.lock;
            ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)$receiver$iv).readLock();
            int n2 = ((ReentrantReadWriteLock)$receiver$iv).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)$receiver$iv).getReadHoldCount() : 0;
            int n3 = 0;
            int n4 = n2 - 1;
            if (n3 <= n4) {
                do {
                    n = ++n3;
                    readLock.unlock();
                } while (n3 != n4);
            }
            ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)$receiver$iv).writeLock();
            writeLock.lock();
            try {
                Path file = this.dir.resolve(path);
                PathKt.write((Path)file, (byte[])content, (int)0, (int)size);
                Path path2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
                this.addToIndex(path2, path, content, size);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n = 0;
                int n5 = n2 - 1;
                if (n <= n5) {
                    do {
                        int n6 = ++n;
                        readLock.lock();
                    } while (n != n5);
                }
                writeLock.unlock();
            }
        }
        catch (Exception e) {
            IcsManagerKt.getLOG().error((Throwable)e);
            return false;
        }
        return true;
    }

    protected abstract void addToIndex(@NotNull Path var1, @NotNull String var2, @NotNull byte[] var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(@NotNull String path) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Logger $receiver$iv = IcsManagerKt.getLOG();
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Remove " + path;
            logger.debug(string);
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2 - 1;
        if (n3 <= n4) {
            do {
                n = ++n3;
                readLock.unlock();
            } while (n3 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Path file = this.dir.resolve(path);
            if (PathKt.exists((Path)file)) {
                Path path2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
                this.delete(path2, path);
                boolean bl = true;
                return bl;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n5 = n2 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
        return false;
    }

    private final void delete(Path file, String path) {
        boolean isFile = PathKt.isFile((Path)file);
        BaseRepositoryManagerKt.removeWithParentsIfEmpty(file, this.dir, isFile);
        this.deleteFromIndex(path, isFile);
    }

    protected abstract void deleteFromIndex(@NotNull String var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean has(@NotNull String path) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            bl = PathKt.exists((Path)this.dir.resolve(path));
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    @NotNull
    protected final Path getDir() {
        return this.dir;
    }

    public BaseRepositoryManager(@NotNull Path dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        this.dir = dir;
        this.lock = new ReentrantReadWriteLock();
    }
}

