/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.boot.application.config.SpringBootPlaceholderReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.additional.DefineLocalMetaConfigKeyFix;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringBootConfigFileHighlightingUtil {
    private static final Condition<PsiReference> RELEVANT_REFERENCE_CONDITION = reference -> !reference.isSoft() && !(reference instanceof SpringBootPlaceholderReference);
    private final ProblemsHolder myHolder;

    public SpringBootConfigFileHighlightingUtil(ProblemsHolder holder) {
        this.myHolder = holder;
    }

    public void highlightValueReferences(@NotNull PsiElement valueElement) {
        if (valueElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueElement", "com/intellij/spring/boot/application/config/SpringBootConfigFileHighlightingUtil", "highlightValueReferences"));
        }
        List valueReferences = ContainerUtil.filter((Object[])valueElement.getReferences(), RELEVANT_REFERENCE_CONDITION);
        SmartList problematicReferences = new SmartList();
        boolean hasValidValueReference = false;
        for (PsiReference reference : valueReferences) {
            boolean unresolved;
            boolean bl = reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false).length == 0 : (unresolved = reference.resolve() == null);
            if (unresolved) {
                problematicReferences.add(reference);
                continue;
            }
            if (reference instanceof JavaClassReference && reference.resolve() instanceof PsiClass) {
                hasValidValueReference = true;
                SpringBootConfigFileHighlightingUtil.highlightJavaClassReferenceExtends(this.myHolder, reference);
                continue;
            }
            if (reference instanceof JavaClassReference) continue;
            hasValidValueReference = true;
        }
        if (!hasValidValueReference) {
            for (PsiReference reference : problematicReferences) {
                this.myHolder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.ERROR);
            }
        }
    }

    private static void highlightJavaClassReferenceExtends(ProblemsHolder holder, PsiReference reference) {
        JavaClassReference javaClassReference = (JavaClassReference)reference;
        String[] extendClassNames = javaClassReference.getExtendClassNames();
        if (extendClassNames == null) {
            return;
        }
        PsiElement resolve = reference.resolve();
        assert (resolve instanceof PsiClass) : resolve;
        for (String extend : extendClassNames) {
            if (!InheritanceUtil.isInheritor((PsiClass)((PsiClass)resolve), (String)extend)) continue;
            return;
        }
        holder.registerProblem(reference.getElement(), ElementManipulators.getValueText((PsiElement)reference.getElement()) + " is not assignable to " + StringUtil.join((String[])extendClassNames, (String)"|"), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
    }

    public void highlightDeprecatedConfigKey(PsiElement keyElement, SpringBootApplicationMetaConfigKey configKey, LocalQuickFix ... quickFixes) {
        String reasonShortText = configKey.getDeprecation().getReason().getShortText();
        String reason = StringUtil.isNotEmpty((String)reasonShortText) ? ": " + reasonShortText : " configuration property '" + configKey.getName() + "'";
        this.myHolder.registerProblem(keyElement, "Deprecated" + reason, ProblemHighlightType.LIKE_DEPRECATED, quickFixes);
    }

    public void highlightUnresolvedConfigKey(PsiElement keyElement, String qualifiedConfigKeyName) {
        this.myHolder.registerProblem(keyElement, "Can not resolve configuration property '" + qualifiedConfigKeyName + "'", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new DefineLocalMetaConfigKeyFix(qualifiedConfigKeyName)});
    }
}

