/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RelaxedNames
implements Iterable<String> {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("([^A-Z-])([A-Z])");
    private static final Pattern SEPARATED_TO_CAMEL_CASE_PATTERN = Pattern.compile("[_\\-.]");
    private final Set<String> values = new LinkedHashSet<String>();

    public RelaxedNames(String name) {
        RelaxedNames.initialize(StringUtil.notNullize((String)name), this.values);
    }

    public Set<String> getValues() {
        return this.values;
    }

    @Override
    public Iterator<String> iterator() {
        return this.values.iterator();
    }

    private static void initialize(String name, Set<String> values) {
        if (values.contains(name)) {
            return;
        }
        for (Variation variation : Variation.values()) {
            for (Manipulation manipulation : Manipulation.values()) {
                String result = name;
                result = manipulation.apply(result);
                result = variation.apply(result);
                values.add(result);
                RelaxedNames.initialize(result, values);
            }
        }
    }

    static enum Manipulation {
        NONE{

            @Override
            public String apply(String value) {
                return value;
            }
        }
        ,
        HYPHEN_TO_UNDERSCORE{

            @Override
            public String apply(String value) {
                return StringUtil.replaceChar((String)value, (char)'-', (char)'_');
            }
        }
        ,
        UNDERSCORE_TO_PERIOD{

            @Override
            public String apply(String value) {
                return StringUtil.replaceChar((String)value, (char)'_', (char)'.');
            }
        }
        ,
        PERIOD_TO_UNDERSCORE{

            @Override
            public String apply(String value) {
                return StringUtil.replaceChar((String)value, (char)'.', (char)'_');
            }
        }
        ,
        CAMELCASE_TO_UNDERSCORE{

            @Override
            public String apply(String value) {
                Matcher matcher = CAMEL_CASE_PATTERN.matcher(value);
                StringBuffer result = new StringBuffer();
                while (matcher.find()) {
                    matcher.appendReplacement(result, matcher.group(1) + '_' + StringUtil.decapitalize((String)matcher.group(2)));
                }
                matcher.appendTail(result);
                return result.toString();
            }
        }
        ,
        CAMELCASE_TO_HYPHEN{

            @Override
            public String apply(String value) {
                Matcher matcher = CAMEL_CASE_PATTERN.matcher(value);
                StringBuffer result = new StringBuffer();
                while (matcher.find()) {
                    matcher.appendReplacement(result, matcher.group(1) + '-' + StringUtil.decapitalize((String)matcher.group(2)));
                }
                matcher.appendTail(result);
                return result.toString();
            }
        }
        ,
        SEPARATED_TO_CAMELCASE{

            @Override
            public String apply(String value) {
                return Manipulation.separatedToCamelCase(value, false);
            }
        }
        ,
        CASE_INSENSITIVE_SEPARATED_TO_CAMELCASE{

            @Override
            public String apply(String value) {
                return Manipulation.separatedToCamelCase(value, true);
            }
        };


        public abstract String apply(String var1);

        private static String separatedToCamelCase(String value, boolean caseInsensitive) {
            StringBuilder builder = new StringBuilder();
            for (String field : SEPARATED_TO_CAMEL_CASE_PATTERN.split(value)) {
                field = caseInsensitive ? field.toLowerCase() : field;
                builder.append(builder.length() == 0 ? field : StringUtil.capitalize((String)field));
            }
            for (String suffix : new String[]{"_", "-", "."}) {
                if (!value.endsWith(suffix)) continue;
                builder.append(suffix);
            }
            return builder.toString();
        }
    }

    static enum Variation {
        NONE{

            @Override
            public String apply(String value) {
                return value;
            }
        }
        ,
        LOWERCASE{

            @Override
            public String apply(String value) {
                return value.toLowerCase(Locale.US);
            }
        }
        ,
        UPPERCASE{

            @Override
            public String apply(String value) {
                return value.toUpperCase(Locale.US);
            }
        };


        public abstract String apply(String var1);
    }
}

