/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssMediumList;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssUriImpl;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CssImportImpl
extends CssElementImpl
implements CssImport {
    public static final ArrayFactory<CssImport> ARRAY_FACTORY = count -> count == 0 ? CssImport.EMPTY_ARRAY : new CssImport[count];

    CssImportImpl() {
        super(CssElementTypes.CSS_IMPORT);
    }

    @NotNull
    public String[] getUriStrings() {
        String[] stringArray = (String[])ContainerUtil.map2Array((Object[])this.getUriElements(), String.class, element -> ElementManipulators.getValueText((PsiElement)element));
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssImportImpl", "getUriStrings"));
        }
        return stringArray;
    }

    @NotNull
    public PsiElement[] getUriElements() {
        ArrayList result = ContainerUtil.newArrayList();
        result.addAll(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, CssString.class));
        List uris = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, CssUriImpl.class);
        for (CssUriImpl uri : uris) {
            PsiElement valueElement = uri.getValueElement();
            if (valueElement == null || valueElement instanceof PsiErrorElement) continue;
            result.add(valueElement);
        }
        PsiElement[] psiElementArray = !result.isEmpty() ? result.toArray(new PsiElement[result.size()]) : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssImportImpl", "getUriElements"));
        }
        return psiElementArray;
    }

    @Nullable
    public CssMediumList getMediumList() {
        return (CssMediumList)PsiTreeUtil.getChildOfType((PsiElement)this, CssMediumList.class);
    }

    public boolean isScreen() {
        return this.getMediaTypes().contains(CssMediaType.SCREEN);
    }

    @NotNull
    public Set<CssMediaType> getMediaTypes() {
        CssMediumList mediumList = this.getMediumList();
        Set set = mediumList != null ? mediumList.getTypes() : ContainerUtil.newHashSet((Object[])new CssMediaType[]{CssMediaType.SCREEN});
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssImportImpl", "getMediaTypes"));
        }
        return set;
    }

    @Nullable
    public CssAtRule getSupports() {
        return (CssAtRule)ObjectUtils.tryCast((Object)this.findPsiChildByType(CssElementTypes.CSS_SUPPORTS), CssAtRule.class);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssImportImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssImport((CssImport)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiFile[] resolve() {
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiElement element : this.getUriElements()) {
            Collections.addAll(result, CssResolveManager.getInstance().resolveFiles(element, this.getContainingFile()));
        }
        PsiFile[] psiFileArray = !result.isEmpty() ? result.toArray(new PsiFile[result.size()]) : PsiFile.EMPTY_ARRAY;
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssImportImpl", "resolve"));
        }
        return psiFileArray;
    }
}

