/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.util.references.CssFontFamilyReference;
import com.intellij.psi.css.impl.util.references.CssIdentifierReference;
import com.intellij.psi.css.impl.util.references.CssKeyframesReference;
import com.intellij.psi.css.index.CssIndex;
import com.intellij.psi.css.resolve.CssCustomPropertyReference;
import com.intellij.psi.css.resolve.CssReferenceProviderUtil;
import com.intellij.psi.css.resolve.CssSelectorSelfReference;
import com.intellij.psi.css.resolve.CssSimpleSelectorReference;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssReferenceProvider
extends PsiReferenceProvider {
    public static final FileType[] IMAGE_FILE_TYPES = new FileType[]{ImageFileTypeManager.getInstance().getImageFileType()};

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)element, () -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssReferenceProvider", "lambda$getReferencesByElement$0"));
            }
            return CachedValueProvider.Result.create((Object)CssReferenceProvider.getReferences(element), (Object[])new Object[]{element});
        });
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static PsiReference[] getReferences(PsiElement element) {
        if (element instanceof CssIdSelector) {
            int startOffset = element.getTextOffset() - element.getTextRange().getStartOffset();
            CssSelectorSuffix selectorSuffix = (CssSelectorSuffix)element;
            return new PsiReference[]{new CssSelectorSelfReference(selectorSuffix, TextRange.from((int)startOffset, (int)StringUtil.length((CharSequence)selectorSuffix.getName())))};
        }
        PsiElement parent = element.getParent();
        if (parent instanceof CssSimpleSelector) {
            return new PsiReference[]{new CssSimpleSelectorReference(element)};
        }
        if (parent instanceof CssPseudoSelector || element instanceof CssFunction) {
            return PsiReference.EMPTY_ARRAY;
        }
        IElementType elementType = element.getNode().getElementType();
        if (CssReferenceProvider.isStringOrUrl(element)) {
            if (CssReferenceProvider.isInImport(element)) {
                return CssReferenceProviderUtil.getFileReferences(element, true, false, new FileType[0]);
            }
            if (CssReferenceProvider.isInsideImageFunction(element) || CssReferenceProvider.isUriElement(element)) {
                return CssReferenceProviderUtil.getFileReferences(element, false, true, IMAGE_FILE_TYPES);
            }
            if (CssReferenceProvider.isSimpleString(element) && CssReferenceProvider.isFontFamilyPropertyValue(element)) {
                return new PsiReference[]{new CssFontFamilyReference((CssString)element)};
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (elementType == CssElementTypes.CSS_IDENT) {
            String propertyName;
            CssDeclaration declaration;
            if (CssPsiUtil.isCustomVariableReference((PsiElement)element)) {
                return new PsiReference[]{new CssCustomPropertyReference(element)};
            }
            if (parent instanceof CssTerm && (declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)parent, CssDeclaration.class)) != null && ("animation-name".equalsIgnoreCase(propertyName = declaration.getPropertyName()) || "animation".equalsIgnoreCase(propertyName))) {
                return new PsiReference[]{new CssKeyframesReference(element)};
            }
        }
        if (elementType == CssElementTypes.CSS_HASH || elementType == CssElementTypes.CSS_IDENT) {
            PsiElement elementParent = element.getParent();
            if (elementParent instanceof CssDeclaration && ((CssDeclaration)elementParent).isCustomProperty() && element.equals(((CssDeclaration)elementParent).getPropertyNameElement())) {
                return PsiReference.EMPTY_ARRAY;
            }
            return new PsiReference[]{new CssIdentifierReference(element)};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static boolean isStringOrUrl(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssReferenceProvider", "isStringOrUrl"));
        }
        return element instanceof CssString || CssReferenceProvider.isUriElement(element);
    }

    private static boolean isFontFamilyPropertyValue(@Nullable PsiElement element) {
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class, (boolean)true);
        if (declaration != null) {
            for (CssPropertyDescriptor descriptor : declaration.getDescriptors()) {
                if (!CssIndex.isFontOrFontFamily(descriptor.getPropertyName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isUriElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssReferenceProvider", "isUriElement"));
        }
        PsiElement parent = element.getParent();
        return parent instanceof CssUri || parent instanceof CssTerm && parent.getParent() instanceof CssUri;
    }

    @Contract(value="null -> false")
    private static boolean isSimpleString(@Nullable PsiElement string) {
        if (string == null || !(string instanceof CssString)) {
            return false;
        }
        PsiElement[] children = string.getChildren();
        return children.length == 1 && children[0].getNode().getElementType() == CssElementTypes.CSS_STRING_TOKEN;
    }

    public static boolean isInImport(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssReferenceProvider", "isInImport"));
        }
        PsiElement parent = element.getParent();
        return parent instanceof CssImport || parent instanceof CssUri && parent.getParent() instanceof CssImport;
    }

    public static boolean isInsideImageFunction(@Nullable PsiElement element) {
        CssFunction function = (CssFunction)PsiTreeUtil.getParentOfType((PsiElement)element, CssFunction.class);
        return function != null && "image".equalsIgnoreCase(function.getName());
    }

    public static class CssReferenceFilter
    implements ElementFilter {
        public boolean isAcceptable(Object element, PsiElement context) {
            PsiElement psiElement = (PsiElement)element;
            if (!psiElement.isValid()) {
                return false;
            }
            if (CssPsiUtil.getStylesheetLanguage((PsiElement)context) == null && context.getContainingFile().getFileType() != CssFileType.INSTANCE && !CssSupportLoader.isInFileThatSupportsCssResolve(context)) {
                return false;
            }
            if (element instanceof CssIdSelector) {
                return true;
            }
            if (element instanceof CssTokenImpl) {
                PsiElement parent = psiElement.getParent();
                if (parent != null) {
                    if (parent instanceof CssDeclaration || parent instanceof CssSimpleSelector || parent instanceof CssFunction) {
                        return true;
                    }
                    PsiElement grandParent = parent.getParent();
                    if (grandParent != null && (grandParent instanceof CssTermList || grandParent.getParent() instanceof CssTermList) && PsiTreeUtil.getParentOfType((PsiElement)parent, CssDeclaration.class) != null || parent instanceof CssUri) {
                        return true;
                    }
                }
            } else if (CssReferenceProvider.isStringOrUrl(psiElement)) {
                return true;
            }
            return false;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }
}

