/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.template.emmet.completion.EmmetAbbreviationCompletionProvider;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssKeyframesSelector;
import com.intellij.psi.css.CssMediaExpression;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssMediaQueryImpl;
import com.intellij.psi.css.impl.util.completion.CssImportantInsertHandler;
import com.intellij.psi.css.impl.util.completion.PercentageUserLookup;
import com.intellij.psi.css.impl.util.completion.provider.CssAndOrKeywordsCompletionProvider;
import com.intellij.psi.css.impl.util.completion.provider.CssAtKeywordsCompletionProvider;
import com.intellij.psi.css.impl.util.completion.provider.CssAttrFunctionReturnValueTypeCompletionProvider;
import com.intellij.psi.css.impl.util.completion.provider.CssCharsetCompletionProvider;
import com.intellij.psi.css.impl.util.completion.provider.CssMediaFeatureNamesCompletionProvider;
import com.intellij.psi.css.impl.util.completion.provider.CssMediaTypeCompletionProvider;
import com.intellij.psi.css.impl.util.completion.provider.CssValueUnitsCompletionProvider;
import com.intellij.psi.css.impl.util.completion.provider.PropertyNamesCompletionProvider;
import com.intellij.psi.css.impl.util.completion.provider.PseudoSelectorsCompletionProvider;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class CssDumbAwareCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final PsiElementPattern.Capture<PsiElement> IMPORTANT_PATTERN = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).inside(CssDeclaration.class)).afterLeafSkipping(StandardPatterns.alwaysFalse(), (ElementPattern)PlatformPatterns.psiElement().withText("!"));
    private static final PsiElementPattern.Capture<PsiElement> KEYFRAMES_SELECTOR_PATTERN = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(CssKeyframesSelector.class);

    public CssDumbAwareCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)CssDumbAwareCompletionContributor.propertyName(), new PropertyNamesCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)CssDumbAwareCompletionContributor.pseudoSelectors(), new PseudoSelectorsCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)CssDumbAwareCompletionContributor.mediaType(), new CssMediaTypeCompletionProvider());
        this.extend(CompletionType.BASIC, CssDumbAwareCompletionContributor.mediaQueryKeywords(), new CssAndOrKeywordsCompletionProvider(false, true));
        this.extend(CompletionType.BASIC, CssDumbAwareCompletionContributor.mediaFeatureName(), new CssMediaFeatureNamesCompletionProvider());
        this.extend(CompletionType.BASIC, CssDumbAwareCompletionContributor.charsetName(), new CssCharsetCompletionProvider());
        this.extend(CompletionType.BASIC, CssDumbAwareCompletionContributor.valueUnits(), new CssValueUnitsCompletionProvider());
        this.extend(CompletionType.BASIC, CssDumbAwareCompletionContributor.atKeyword(), new CssAtKeywordsCompletionProvider());
        this.extend(CompletionType.BASIC, CssDumbAwareCompletionContributor.supportsUnknownConditionList(), new CssAndOrKeywordsCompletionProvider(true, true));
        this.extend(CompletionType.BASIC, CssDumbAwareCompletionContributor.supportsAndConditionList(), new CssAndOrKeywordsCompletionProvider(false, true));
        this.extend(CompletionType.BASIC, CssDumbAwareCompletionContributor.supportsOrConditionList(), new CssAndOrKeywordsCompletionProvider(true, false));
        this.extend(CompletionType.BASIC, CssDumbAwareCompletionContributor.emmetFuzzyAbbreviations(), (CompletionProvider)new EmmetAbbreviationCompletionProvider());
        this.extend(CompletionType.BASIC, CssDumbAwareCompletionContributor.attrFunctionReturnValueType(), new CssAttrFunctionReturnValueTypeCompletionProvider());
    }

    public static ElementPattern<? extends PsiElement> atKeyword() {
        return PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_ATKEYWORD);
    }

    private static ElementPattern<? extends PsiElement> valueUnits() {
        return PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).afterLeafSkipping(StandardPatterns.alwaysFalse(), (ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_NUMBER));
    }

    private static ElementPattern<? extends PsiElement> charsetName() {
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_STRING_TOKEN).withParent(CssString.class)).withSuperParent(2, CssCharset.class);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/completion/CssDumbAwareCompletionContributor", "beforeCompletion"));
        }
        PsiElement at = context.getFile().findElementAt(context.getStartOffset());
        if (CssPsiUtil.getStylesheetLanguage((PsiElement)at) != null && CssDumbAwareCompletionContributor.pseudoSelectors().accepts((Object)at)) {
            context.setReplacementOffset(at.getTextRange().getEndOffset());
        }
    }

    public static PsiElementPattern.Capture<PsiElement> propertyName() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).atStartOf((ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_DECLARATION));
    }

    private static ElementPattern<? extends PsiElement> mediaQueryKeywords() {
        return ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withSuperParent(2, CssMediaQueryImpl.class)).andNot((ElementPattern)PlatformPatterns.psiElement().afterLeaf(new String[]{","}))).andOr(new ElementPattern[]{StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement().afterSiblingSkipping((ElementPattern)PlatformPatterns.psiElement(CssMediaExpression.class), (ElementPattern)PlatformPatterns.psiElement().whitespaceCommentEmptyOrError())), PlatformPatterns.psiElement().afterLeaf(new String[]{")"})});
    }

    private static ElementPattern<? extends PsiElement> mediaFeatureName() {
        return PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).atStartOf((ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_MEDIA_FEATURE));
    }

    private static PsiElementPattern.Capture<PsiElement> pseudoSelectors() {
        return (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withParent((ElementPattern)PlatformPatterns.psiElement(CssPseudoSelector.class))).afterLeaf(new String[]{":"});
    }

    private static PsiElementPattern.Capture<PsiElement> mediaType() {
        return (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withParent(CssMediaQueryImpl.class)).andOr(new ElementPattern[]{PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_MEDIA_SYM, CssElementTypes.CSS_STRING_TOKEN}))), PlatformPatterns.psiElement().afterLeaf(new String[]{",", "only", "not"})});
    }

    private static ElementPattern<? extends PsiElement> supportsUnknownConditionList() {
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_SUPPORTS_CONDITION_UNKNOWN_LIST))).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(CssDeclaration.class));
    }

    private static ElementPattern<? extends PsiElement> supportsAndConditionList() {
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_SUPPORTS_CONDITION_AND_LIST))).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(CssDeclaration.class));
    }

    private static ElementPattern<? extends PsiElement> supportsOrConditionList() {
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_SUPPORTS_CONDITION_OR_LIST))).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(CssDeclaration.class));
    }

    private static ElementPattern<? extends PsiElement> attrFunctionReturnValueType() {
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_IDENT).andNot((ElementPattern)PlatformPatterns.psiElement().afterLeaf(new String[]{","}))).withSuperParent(3, (ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_FUNCTION).withName("attr"));
    }

    private static ElementPattern<PsiElement> emmetFuzzyAbbreviations() {
        return StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().inFile((ElementPattern)PlatformPatterns.psiFile(CssFile.class)), PlatformPatterns.psiElement(CssElement.class)});
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/css/impl/util/completion/CssDumbAwareCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/CssDumbAwareCompletionContributor", "fillCompletionVariants"));
        }
        super.fillCompletionVariants(parameters, CssCompletionUtil.fixPrefixForVendorPrefixes(parameters, result, new IElementType[0]));
        if (!result.isStopped()) {
            PsiElement position = parameters.getPosition();
            if (IMPORTANT_PATTERN.accepts((Object)position)) {
                result.addElement(CssCompletionUtil.lookupForKeyword("important", CssImportantInsertHandler.INSTANCE));
            }
            if (KEYFRAMES_SELECTOR_PATTERN.accepts((Object)position)) {
                result.addElement(new PercentageUserLookup().lookup());
            }
        }
    }
}

