/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssCustomMixin;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssKeyframesSelector;
import com.intellij.psi.css.CssMediaFeature;
import com.intellij.psi.css.CssNamespace;
import com.intellij.psi.css.CssNamespaceList;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssSupportsCondition;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssRulesetWrappingElement;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlToken;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CssFormattingElementVisitor
extends CssElementVisitor {
    private boolean mySeenRuleset;
    protected final List<Block> mySubBlocks;
    private final CssCodeStyleSettings mySettings;
    private final int myMaxPropertyLength;
    private final CssFormattingModelBuilder.CssFormattingExtension myExtension;
    private final Alignment alignment;
    private final Alignment myChildAlignment;
    private final IElementType myType;
    private final boolean shouldIndentContent;

    public CssFormattingElementVisitor(List<Block> blocks, CssCodeStyleSettings settings, int length, CssFormattingModelBuilder.CssFormattingExtension extension, Alignment alignment, Alignment childAlignment, IElementType type, boolean content) {
        this.mySubBlocks = blocks;
        this.mySettings = settings;
        this.myMaxPropertyLength = length;
        this.myExtension = extension;
        this.alignment = alignment;
        this.myChildAlignment = childAlignment;
        this.myType = type;
        this.shouldIndentContent = content;
    }

    public void visitCssString(CssString _string) {
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(_string.getNode(), this.mySettings, Indent.getNoneIndent(), this.myMaxPropertyLength, this.myExtension));
    }

    public void visitNamespace(CssNamespace namespace) {
        this.mySubBlocks.add((Block)this.myExtension.createPropertyBlock(namespace.getNode(), this.mySettings, this.myMaxPropertyLength, this.myExtension, -1, null, this.alignment));
    }

    public void visitCssImport(CssImport _import) {
        this.mySubBlocks.add((Block)this.myExtension.createPropertyBlock(_import.getNode(), this.mySettings, this.myMaxPropertyLength, this.myExtension, -1, null, this.alignment));
    }

    public void visitCustomMixin(@NotNull CssCustomMixin customMixin) {
        if (customMixin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customMixin", "com/intellij/psi/css/impl/util/editor/CssFormattingElementVisitor", "visitCustomMixin"));
        }
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)this.myExtension.createRulesetBlock(customMixin.getNode(), this.mySettings, indent, this.myMaxPropertyLength, this.myExtension, this.alignment));
    }

    public void visitXmlToken(XmlToken token) {
        if (!this.myExtension.addXmlBlock(token)) {
            Indent indent = this.myExtension.getTokenIndent(token, this.mySettings, this.myType);
            this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(token.getNode(), this.mySettings, indent, this.myMaxPropertyLength, this.myExtension, this.mySettings.VALUE_ALIGNMENT == 1 && token.getTokenType() == CssElementTypes.CSS_COLON ? this.myChildAlignment : null));
        }
    }

    public void visitCssRuleset(CssRuleset ruleset) {
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)this.myExtension.createRulesetBlock(ruleset.getNode(), this.mySettings, indent, this.myMaxPropertyLength, this.myExtension, (Alignment)(this.mySeenRuleset ? Alignment.createAlignment() : null)));
        this.mySeenRuleset = true;
    }

    public void visitCssSelector(CssSelector selector) {
        boolean containsOuterLangElements = false;
        for (PsiElement child = selector.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof OuterLanguageElement)) continue;
            containsOuterLangElements = true;
            break;
        }
        if (containsOuterLangElements) {
            selector.acceptChildren((PsiElementVisitor)this);
        } else {
            this.mySubBlocks.add((Block)this.myExtension.createSelectorBlock(selector.getNode(), this.mySettings, this.myMaxPropertyLength, this.myExtension));
        }
    }

    public void visitCssSimpleSelector(CssSimpleSelector selector) {
        if (selector != null && !(selector instanceof CssKeyframesSelector) && !FormatterUtil.containsWhiteSpacesOnly((ASTNode)selector.getNode())) {
            this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(selector.getNode(), this.mySettings, Indent.getNoneIndent(), this.myMaxPropertyLength, this.myExtension));
        }
    }

    public void visitCssTermList(CssTermList _termList) {
        boolean errorsOnly = true;
        for (PsiElement child = _termList.getFirstChild(); child != null && !(errorsOnly = child instanceof PsiErrorElement); child = child.getNextSibling()) {
        }
        if (errorsOnly) {
            _termList.acceptChildren((PsiElementVisitor)this);
        } else {
            Indent indent = this.shouldIndentContent ? Indent.getContinuationIndent() : Indent.getNoneIndent();
            this.mySubBlocks.add((Block)this.myExtension.createTermListBlock(_termList.getNode(), this.mySettings, indent, this.myMaxPropertyLength, -1, this.mySettings.VALUE_ALIGNMENT == 2 ? this.myChildAlignment : null, true));
        }
    }

    public void visitCssDeclaration(CssDeclaration declaration) {
        this.mySubBlocks.add((Block)this.myExtension.createPropertyBlock(declaration.getNode(), this.mySettings, this.myMaxPropertyLength, this.myExtension, declaration.getPropertyName().length(), null, this.alignment));
    }

    public void visitMediaFeature(@NotNull CssMediaFeature mediaFeature) {
        if (mediaFeature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mediaFeature", "com/intellij/psi/css/impl/util/editor/CssFormattingElementVisitor", "visitMediaFeature"));
        }
        this.mySubBlocks.add((Block)this.myExtension.createPropertyBlock(mediaFeature.getNode(), this.mySettings, this.myMaxPropertyLength, this.myExtension, mediaFeature.getName().length(), null, null));
    }

    private void visitMediaGroup(PsiElement mediaGroup) {
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)this.myExtension.createMediaBlock(mediaGroup.getNode(), this.mySettings, indent, this.myMaxPropertyLength, this.myExtension));
    }

    private void visitPageDeclaration(PsiElement page) {
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssPageBlock(page.getNode(), this.mySettings, indent, this.myMaxPropertyLength, this.myExtension));
    }

    private void visitSupportsDeclaration(PsiElement supports) {
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)this.myExtension.createSupportsBlock(supports.getNode(), this.mySettings, indent, this.myMaxPropertyLength, this.myExtension));
    }

    private void visitSupportsCondition(PsiElement condition) {
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(condition.getNode(), this.mySettings, Indent.getNoneIndent(), this.myMaxPropertyLength, this.myExtension));
    }

    private void visitCssOperationBlock(PsiElement operation) {
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssOperationBlock(operation.getNode(), this.mySettings, this.myMaxPropertyLength, this.myExtension));
    }

    public void visitNamespaceList(CssNamespaceList namespaceList) {
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.NamespaceListBlock(namespaceList.getNode(), this.mySettings, this.myMaxPropertyLength, this.myExtension));
    }

    private void visitCssImportList(@NotNull PsiElement importList) {
        if (importList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importList", "com/intellij/psi/css/impl/util/editor/CssFormattingElementVisitor", "visitCssImportList"));
        }
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.ImportListBlock(importList.getNode(), this.mySettings, this.myMaxPropertyLength, this.myExtension));
    }

    private void visitBadAtRule(@NotNull PsiElement badAtRule) {
        if (badAtRule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "badAtRule", "com/intellij/psi/css/impl/util/editor/CssFormattingElementVisitor", "visitBadAtRule"));
        }
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssBadAtRuleBlock(badAtRule.getNode(), this.mySettings, indent, this.myMaxPropertyLength, this.myExtension));
        this.mySeenRuleset = true;
    }

    private void visitCssExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/css/impl/util/editor/CssFormattingElementVisitor", "visitCssExpression"));
        }
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(expression.getNode(), this.mySettings, Indent.getNoneIndent(), this.myMaxPropertyLength, this.myExtension));
    }

    private void visitCssFontFace(@NotNull PsiElement fontFace) {
        if (fontFace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFace", "com/intellij/psi/css/impl/util/editor/CssFormattingElementVisitor", "visitCssFontFace"));
        }
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssFontFaceBlock(fontFace.getNode(), this.mySettings, indent, this.myMaxPropertyLength, this.myExtension));
    }

    private void visitCssViewPort(@NotNull PsiElement viewPort) {
        if (viewPort == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewPort", "com/intellij/psi/css/impl/util/editor/CssFormattingElementVisitor", "visitCssViewPort"));
        }
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssViewPortBlock(viewPort.getNode(), this.mySettings, indent, this.myMaxPropertyLength, this.myExtension));
    }

    private void visitAtRuleWithNestedRulesets(@NotNull PsiElement atRule) {
        if (atRule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atRule", "com/intellij/psi/css/impl/util/editor/CssFormattingElementVisitor", "visitAtRuleWithNestedRulesets"));
        }
        Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
        this.mySubBlocks.add((Block)this.myExtension.createRulesetBlock(atRule.getNode(), this.mySettings, indent, this.myMaxPropertyLength, this.myExtension, Alignment.createAlignment()));
        this.mySeenRuleset = true;
    }

    private void visitCharset(@NotNull PsiElement charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/psi/css/impl/util/editor/CssFormattingElementVisitor", "visitCharset"));
        }
        this.mySubBlocks.add((Block)this.myExtension.createPropertyBlock(charset.getNode(), this.mySettings, this.myMaxPropertyLength, this.myExtension, -1, null, this.alignment));
    }

    public void visitComment(PsiComment comment) {
    }

    public void visitElement(PsiElement element) {
        if (element instanceof CssElement) {
            ASTNode node = element.getNode();
            if (node != null && CssElementTypes.CSS_MEDIA == node.getElementType()) {
                this.visitMediaGroup(element);
            } else if (node != null && CssElementTypes.CSS_PAGE == node.getElementType()) {
                this.visitPageDeclaration(element);
            } else if (node != null && CssElementTypes.CSS_SUPPORTS == node.getElementType()) {
                this.visitSupportsDeclaration(element);
            } else if (node != null && node instanceof CssSupportsCondition) {
                this.visitSupportsCondition(element);
            } else if (node != null && CssElementTypes.CSS_PAGE_MARGIN_RULE == node.getElementType()) {
                this.visitBadAtRule(element);
            } else if (node != null && CssElementTypes.CSS_IMPORT_LIST == node.getElementType()) {
                this.visitCssImportList(element);
            } else if (element instanceof CssTermList) {
                this.visitCssTermList((CssTermList)element);
            } else if (node != null && CssElementTypes.CSS_EXPRESSION == node.getElementType()) {
                this.visitCssExpression(element);
            } else if (node != null && CssElementTypes.CSS_FONTFACE == node.getElementType()) {
                this.visitCssFontFace(element);
            } else if (node != null && CssElementTypes.CSS_VIEWPORT == node.getElementType()) {
                this.visitCssViewPort(element);
            } else if (node != null && CssElementTypes.CSS_ATTRIBUTE == node.getElementType()) {
                this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(node, this.mySettings, Indent.getNoneIndent(), this.myMaxPropertyLength, this.myExtension));
            } else if (node != null && (CssElementTypes.CSS_BINARY_OPERATION == node.getElementType() || CssElementTypes.CSS_UNARY_OPERATION == node.getElementType())) {
                this.visitCssOperationBlock(element);
            } else if (node != null && CssElementTypes.CSS_KEYFRAMES_RULE == node.getElementType() || node != null && CssElementTypes.CSS_REGION_RULE == node.getElementType() || node != null && CssElementTypes.CSS_SCOPE_RULE == node.getElementType() || node != null && CssElementTypes.CSS_DOCUMENT_RULE == node.getElementType()) {
                this.visitAtRuleWithNestedRulesets(element);
            } else if (node != null && CssElementTypes.CSS_CHARSET == node.getElementType()) {
                this.visitCharset(element);
            } else if (node != null && CssElementTypes.CSS_APPLY == node.getElementType()) {
                this.mySubBlocks.add((Block)this.myExtension.createPropertyBlock(node, this.mySettings, this.myMaxPropertyLength, this.myExtension, -1, null, this.alignment));
            } else if (node != null && (CssElementTypes.CSS_BAD_AT_RULE == node.getElementType() || element instanceof CssAtRule)) {
                this.visitBadAtRule(element);
            } else if (!FormatterUtil.containsWhiteSpacesOnly((ASTNode)node) && !this.myExtension.addSubBlocks(element, this.mySettings, this.myMaxPropertyLength, this.mySubBlocks)) {
                if (element.getLanguage() == CSSLanguage.INSTANCE || element instanceof CssStylesheet || element instanceof CssBlock || element instanceof CssRulesetWrappingElement) {
                    element.acceptChildren((PsiElementVisitor)this);
                } else if (!this.myExtension.addSubBlocksOfExtendedLanguage(element, this.mySettings, this.myMaxPropertyLength, this.mySubBlocks)) {
                    Indent indent = this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent();
                    this.mySubBlocks.add((Block)new CssFormattingModelBuilder.LeafBlock(node, indent));
                }
            }
        } else if (element instanceof PsiErrorElement) {
            element.acceptChildren((PsiElementVisitor)this);
        } else if (element instanceof OuterLanguageElement || element.getNode() != null && element.getNode().getElementType() == CssElementTypes.CSS_BAD_CHARACTER) {
            this.mySubBlocks.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(element.getNode(), this.mySettings, Indent.getNoneIndent(), this.myMaxPropertyLength, this.myExtension));
        } else {
            ASTNode node = element.getNode();
            if (!FormatterUtil.containsWhiteSpacesOnly((ASTNode)node) && !this.myExtension.addSubBlocksOfExtendedLanguage(element, this.mySettings, this.myMaxPropertyLength, this.mySubBlocks)) {
                this.mySubBlocks.add((Block)new CssFormattingModelBuilder.LeafBlock(node, this.shouldIndentContent ? Indent.getNormalIndent() : Indent.getNoneIndent()));
            }
        }
    }
}

